/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.resources.ExperimentName;
import com.google.ads.googleads.v20.services.CampaignBudgetMapping;
import com.google.ads.googleads.v20.services.EndExperimentRequest;
import com.google.ads.googleads.v20.services.ExperimentOperation;
import com.google.ads.googleads.v20.services.ExperimentServiceSettings;
import com.google.ads.googleads.v20.services.GraduateExperimentRequest;
import com.google.ads.googleads.v20.services.ListExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v20.services.ListExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v20.services.MutateExperimentsRequest;
import com.google.ads.googleads.v20.services.MutateExperimentsResponse;
import com.google.ads.googleads.v20.services.PromoteExperimentMetadata;
import com.google.ads.googleads.v20.services.PromoteExperimentRequest;
import com.google.ads.googleads.v20.services.ScheduleExperimentMetadata;
import com.google.ads.googleads.v20.services.ScheduleExperimentRequest;
import com.google.ads.googleads.v20.services.stub.ExperimentServiceStub;
import com.google.ads.googleads.v20.services.stub.ExperimentServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ExperimentServiceClient
implements BackgroundResource {
    private final ExperimentServiceSettings settings;
    private final ExperimentServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ExperimentServiceClient create() throws IOException {
        return ExperimentServiceClient.create(ExperimentServiceSettings.newBuilder().build());
    }

    public static final ExperimentServiceClient create(ExperimentServiceSettings settings) throws IOException {
        return new ExperimentServiceClient(settings);
    }

    public static final ExperimentServiceClient create(ExperimentServiceStub stub) {
        return new ExperimentServiceClient(stub);
    }

    protected ExperimentServiceClient(ExperimentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExperimentServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ExperimentServiceClient(ExperimentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ExperimentServiceSettings getSettings() {
        return this.settings;
    }

    public ExperimentServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final MutateExperimentsResponse mutateExperiments(String customerId, List<ExperimentOperation> operations) {
        MutateExperimentsRequest request = MutateExperimentsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateExperiments(request);
    }

    public final MutateExperimentsResponse mutateExperiments(MutateExperimentsRequest request) {
        return (MutateExperimentsResponse)this.mutateExperimentsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsCallable() {
        return this.stub.mutateExperimentsCallable();
    }

    public final void endExperiment(ExperimentName experiment) {
        EndExperimentRequest request = EndExperimentRequest.newBuilder().setExperiment(experiment == null ? null : experiment.toString()).build();
        this.endExperiment(request);
    }

    public final void endExperiment(String experiment) {
        EndExperimentRequest request = EndExperimentRequest.newBuilder().setExperiment(experiment).build();
        this.endExperiment(request);
    }

    public final void endExperiment(EndExperimentRequest request) {
        this.endExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<EndExperimentRequest, Empty> endExperimentCallable() {
        return this.stub.endExperimentCallable();
    }

    public final ListExperimentAsyncErrorsPagedResponse listExperimentAsyncErrors(ExperimentName resourceName) {
        ListExperimentAsyncErrorsRequest request = ListExperimentAsyncErrorsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.listExperimentAsyncErrors(request);
    }

    public final ListExperimentAsyncErrorsPagedResponse listExperimentAsyncErrors(String resourceName) {
        ListExperimentAsyncErrorsRequest request = ListExperimentAsyncErrorsRequest.newBuilder().setResourceName(resourceName).build();
        return this.listExperimentAsyncErrors(request);
    }

    public final ListExperimentAsyncErrorsPagedResponse listExperimentAsyncErrors(ListExperimentAsyncErrorsRequest request) {
        return (ListExperimentAsyncErrorsPagedResponse)((Object)this.listExperimentAsyncErrorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsPagedCallable() {
        return this.stub.listExperimentAsyncErrorsPagedCallable();
    }

    public final UnaryCallable<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse> listExperimentAsyncErrorsCallable() {
        return this.stub.listExperimentAsyncErrorsCallable();
    }

    public final void graduateExperiment(ExperimentName experiment, List<CampaignBudgetMapping> campaignBudgetMappings) {
        GraduateExperimentRequest request = GraduateExperimentRequest.newBuilder().setExperiment(experiment == null ? null : experiment.toString()).addAllCampaignBudgetMappings(campaignBudgetMappings).build();
        this.graduateExperiment(request);
    }

    public final void graduateExperiment(String experiment, List<CampaignBudgetMapping> campaignBudgetMappings) {
        GraduateExperimentRequest request = GraduateExperimentRequest.newBuilder().setExperiment(experiment).addAllCampaignBudgetMappings(campaignBudgetMappings).build();
        this.graduateExperiment(request);
    }

    public final void graduateExperiment(GraduateExperimentRequest request) {
        this.graduateExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<GraduateExperimentRequest, Empty> graduateExperimentCallable() {
        return this.stub.graduateExperimentCallable();
    }

    public final OperationFuture<Empty, ScheduleExperimentMetadata> scheduleExperimentAsync(ExperimentName resourceName) {
        ScheduleExperimentRequest request = ScheduleExperimentRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.scheduleExperimentAsync(request);
    }

    public final OperationFuture<Empty, ScheduleExperimentMetadata> scheduleExperimentAsync(String resourceName) {
        ScheduleExperimentRequest request = ScheduleExperimentRequest.newBuilder().setResourceName(resourceName).build();
        return this.scheduleExperimentAsync(request);
    }

    public final OperationFuture<Empty, ScheduleExperimentMetadata> scheduleExperimentAsync(ScheduleExperimentRequest request) {
        return this.scheduleExperimentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationCallable() {
        return this.stub.scheduleExperimentOperationCallable();
    }

    public final UnaryCallable<ScheduleExperimentRequest, Operation> scheduleExperimentCallable() {
        return this.stub.scheduleExperimentCallable();
    }

    public final OperationFuture<Empty, PromoteExperimentMetadata> promoteExperimentAsync(ExperimentName resourceName) {
        PromoteExperimentRequest request = PromoteExperimentRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.promoteExperimentAsync(request);
    }

    public final OperationFuture<Empty, PromoteExperimentMetadata> promoteExperimentAsync(String resourceName) {
        PromoteExperimentRequest request = PromoteExperimentRequest.newBuilder().setResourceName(resourceName).build();
        return this.promoteExperimentAsync(request);
    }

    public final OperationFuture<Empty, PromoteExperimentMetadata> promoteExperimentAsync(PromoteExperimentRequest request) {
        return this.promoteExperimentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationCallable() {
        return this.stub.promoteExperimentOperationCallable();
    }

    public final UnaryCallable<PromoteExperimentRequest, Operation> promoteExperimentCallable() {
        return this.stub.promoteExperimentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListExperimentAsyncErrorsPagedResponse
    extends AbstractPagedListResponse<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status, ListExperimentAsyncErrorsPage, ListExperimentAsyncErrorsFixedSizeCollection> {
        public static ApiFuture<ListExperimentAsyncErrorsPagedResponse> createAsync(PageContext<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status> context, ApiFuture<ListExperimentAsyncErrorsResponse> futureResponse) {
            ApiFuture<ListExperimentAsyncErrorsPage> futurePage = ListExperimentAsyncErrorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExperimentAsyncErrorsPagedResponse((ListExperimentAsyncErrorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExperimentAsyncErrorsPagedResponse(ListExperimentAsyncErrorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExperimentAsyncErrorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExperimentAsyncErrorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status, ListExperimentAsyncErrorsPage, ListExperimentAsyncErrorsFixedSizeCollection> {
        private ListExperimentAsyncErrorsFixedSizeCollection(List<ListExperimentAsyncErrorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExperimentAsyncErrorsFixedSizeCollection createEmptyCollection() {
            return new ListExperimentAsyncErrorsFixedSizeCollection(null, 0);
        }

        protected ListExperimentAsyncErrorsFixedSizeCollection createCollection(List<ListExperimentAsyncErrorsPage> pages, int collectionSize) {
            return new ListExperimentAsyncErrorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExperimentAsyncErrorsPage
    extends AbstractPage<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status, ListExperimentAsyncErrorsPage> {
        private ListExperimentAsyncErrorsPage(PageContext<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status> context, ListExperimentAsyncErrorsResponse response) {
            super(context, (Object)response);
        }

        private static ListExperimentAsyncErrorsPage createEmptyPage() {
            return new ListExperimentAsyncErrorsPage(null, null);
        }

        protected ListExperimentAsyncErrorsPage createPage(PageContext<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status> context, ListExperimentAsyncErrorsResponse response) {
            return new ListExperimentAsyncErrorsPage(context, response);
        }

        public ApiFuture<ListExperimentAsyncErrorsPage> createPageAsync(PageContext<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status> context, ApiFuture<ListExperimentAsyncErrorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

