/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountBudgetProposalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ACCOUNT_BUDGET_PROPOSAL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String accountBudgetProposalId;

    @Deprecated
    protected AccountBudgetProposalName() {
        this.customerId = null;
        this.accountBudgetProposalId = null;
    }

    private AccountBudgetProposalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.accountBudgetProposalId = (String)Preconditions.checkNotNull((Object)builder.getAccountBudgetProposalId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAccountBudgetProposalId() {
        return this.accountBudgetProposalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccountBudgetProposalName of(String customerId, String accountBudgetProposalId) {
        return AccountBudgetProposalName.newBuilder().setCustomerId(customerId).setAccountBudgetProposalId(accountBudgetProposalId).build();
    }

    public static String format(String customerId, String accountBudgetProposalId) {
        return AccountBudgetProposalName.newBuilder().setCustomerId(customerId).setAccountBudgetProposalId(accountBudgetProposalId).build().toString();
    }

    public static AccountBudgetProposalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ACCOUNT_BUDGET_PROPOSAL_ID.validatedMatch(formattedString, "AccountBudgetProposalName.parse: formattedString not in valid format");
        return AccountBudgetProposalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("account_budget_proposal_id"));
    }

    public static List<AccountBudgetProposalName> parseList(List<String> formattedStrings) {
        ArrayList<AccountBudgetProposalName> list = new ArrayList<AccountBudgetProposalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountBudgetProposalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountBudgetProposalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountBudgetProposalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ACCOUNT_BUDGET_PROPOSAL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountBudgetProposalName accountBudgetProposalName = this;
            synchronized (accountBudgetProposalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.accountBudgetProposalId != null) {
                        fieldMapBuilder.put((Object)"account_budget_proposal_id", (Object)this.accountBudgetProposalId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ACCOUNT_BUDGET_PROPOSAL_ID.instantiate(new String[]{"customer_id", this.customerId, "account_budget_proposal_id", this.accountBudgetProposalId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccountBudgetProposalName that = (AccountBudgetProposalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.accountBudgetProposalId, that.accountBudgetProposalId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accountBudgetProposalId);
    }

    public static class Builder {
        private String customerId;
        private String accountBudgetProposalId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAccountBudgetProposalId() {
            return this.accountBudgetProposalId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAccountBudgetProposalId(String accountBudgetProposalId) {
            this.accountBudgetProposalId = accountBudgetProposalId;
            return this;
        }

        private Builder(AccountBudgetProposalName accountBudgetProposalName) {
            this.customerId = accountBudgetProposalName.customerId;
            this.accountBudgetProposalId = accountBudgetProposalName.accountBudgetProposalId;
        }

        public AccountBudgetProposalName build() {
            return new AccountBudgetProposalName(this);
        }
    }
}

