/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.ads.googleads.v21.enums.AdGroupAdPrimaryStatusEnum;
import com.google.ads.googleads.v21.enums.AdGroupAdPrimaryStatusReasonEnum;
import com.google.ads.googleads.v21.enums.AdGroupAdStatusEnum;
import com.google.ads.googleads.v21.enums.AdStrengthEnum;
import com.google.ads.googleads.v21.resources.Ad;
import com.google.ads.googleads.v21.resources.AdGroupAdAssetAutomationSetting;
import com.google.ads.googleads.v21.resources.AdGroupAdAssetAutomationSettingOrBuilder;
import com.google.ads.googleads.v21.resources.AdGroupAdOrBuilder;
import com.google.ads.googleads.v21.resources.AdGroupAdPolicySummary;
import com.google.ads.googleads.v21.resources.AdGroupAdPolicySummaryOrBuilder;
import com.google.ads.googleads.v21.resources.AdGroupAdProto;
import com.google.ads.googleads.v21.resources.AdOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AdGroupAd
extends GeneratedMessageV3
implements AdGroupAdOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int STATUS_FIELD_NUMBER = 3;
    private int status_ = 0;
    public static final int AD_GROUP_FIELD_NUMBER = 9;
    private volatile Object adGroup_ = "";
    public static final int AD_FIELD_NUMBER = 5;
    private Ad ad_;
    public static final int POLICY_SUMMARY_FIELD_NUMBER = 6;
    private AdGroupAdPolicySummary policySummary_;
    public static final int AD_STRENGTH_FIELD_NUMBER = 7;
    private int adStrength_ = 0;
    public static final int ACTION_ITEMS_FIELD_NUMBER = 13;
    private LazyStringArrayList actionItems_ = LazyStringArrayList.emptyList();
    public static final int LABELS_FIELD_NUMBER = 10;
    private LazyStringArrayList labels_ = LazyStringArrayList.emptyList();
    public static final int PRIMARY_STATUS_FIELD_NUMBER = 16;
    private int primaryStatus_ = 0;
    public static final int PRIMARY_STATUS_REASONS_FIELD_NUMBER = 17;
    private List<Integer> primaryStatusReasons_;
    private static final Internal.ListAdapter.Converter<Integer, AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason> primaryStatusReasons_converter_ = new Internal.ListAdapter.Converter<Integer, AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason>(){

        public AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason convert(Integer from) {
            AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason result = AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason.forNumber(from);
            return result == null ? AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason.UNRECOGNIZED : result;
        }
    };
    private int primaryStatusReasonsMemoizedSerializedSize;
    public static final int AD_GROUP_AD_ASSET_AUTOMATION_SETTINGS_FIELD_NUMBER = 18;
    private List<AdGroupAdAssetAutomationSetting> adGroupAdAssetAutomationSettings_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AdGroupAd DEFAULT_INSTANCE = new AdGroupAd();
    private static final Parser<AdGroupAd> PARSER = new AbstractParser<AdGroupAd>(){

        public AdGroupAd parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AdGroupAd.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AdGroupAd(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AdGroupAd() {
        this.resourceName_ = "";
        this.status_ = 0;
        this.adGroup_ = "";
        this.adStrength_ = 0;
        this.actionItems_ = LazyStringArrayList.emptyList();
        this.labels_ = LazyStringArrayList.emptyList();
        this.primaryStatus_ = 0;
        this.primaryStatusReasons_ = Collections.emptyList();
        this.adGroupAdAssetAutomationSettings_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AdGroupAd();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AdGroupAdProto.internal_static_google_ads_googleads_v21_resources_AdGroupAd_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AdGroupAdProto.internal_static_google_ads_googleads_v21_resources_AdGroupAd_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupAd.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AdGroupAdStatusEnum.AdGroupAdStatus getStatus() {
        AdGroupAdStatusEnum.AdGroupAdStatus result = AdGroupAdStatusEnum.AdGroupAdStatus.forNumber(this.status_);
        return result == null ? AdGroupAdStatusEnum.AdGroupAdStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAdGroup() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getAdGroup() {
        Object ref = this.adGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.adGroup_ = s;
        return s;
    }

    @Override
    public ByteString getAdGroupBytes() {
        Object ref = this.adGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.adGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasAd() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Ad getAd() {
        return this.ad_ == null ? Ad.getDefaultInstance() : this.ad_;
    }

    @Override
    public AdOrBuilder getAdOrBuilder() {
        return this.ad_ == null ? Ad.getDefaultInstance() : this.ad_;
    }

    @Override
    public boolean hasPolicySummary() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public AdGroupAdPolicySummary getPolicySummary() {
        return this.policySummary_ == null ? AdGroupAdPolicySummary.getDefaultInstance() : this.policySummary_;
    }

    @Override
    public AdGroupAdPolicySummaryOrBuilder getPolicySummaryOrBuilder() {
        return this.policySummary_ == null ? AdGroupAdPolicySummary.getDefaultInstance() : this.policySummary_;
    }

    @Override
    public int getAdStrengthValue() {
        return this.adStrength_;
    }

    @Override
    public AdStrengthEnum.AdStrength getAdStrength() {
        AdStrengthEnum.AdStrength result = AdStrengthEnum.AdStrength.forNumber(this.adStrength_);
        return result == null ? AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
    }

    public ProtocolStringList getActionItemsList() {
        return this.actionItems_;
    }

    @Override
    public int getActionItemsCount() {
        return this.actionItems_.size();
    }

    @Override
    public String getActionItems(int index) {
        return this.actionItems_.get(index);
    }

    @Override
    public ByteString getActionItemsBytes(int index) {
        return this.actionItems_.getByteString(index);
    }

    public ProtocolStringList getLabelsList() {
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.labels_.size();
    }

    @Override
    public String getLabels(int index) {
        return this.labels_.get(index);
    }

    @Override
    public ByteString getLabelsBytes(int index) {
        return this.labels_.getByteString(index);
    }

    @Override
    public int getPrimaryStatusValue() {
        return this.primaryStatus_;
    }

    @Override
    public AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus getPrimaryStatus() {
        AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus result = AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.forNumber(this.primaryStatus_);
        return result == null ? AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason> getPrimaryStatusReasonsList() {
        return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
    }

    @Override
    public int getPrimaryStatusReasonsCount() {
        return this.primaryStatusReasons_.size();
    }

    @Override
    public AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason getPrimaryStatusReasons(int index) {
        return (AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
    }

    @Override
    public List<Integer> getPrimaryStatusReasonsValueList() {
        return this.primaryStatusReasons_;
    }

    @Override
    public int getPrimaryStatusReasonsValue(int index) {
        return this.primaryStatusReasons_.get(index);
    }

    @Override
    public List<AdGroupAdAssetAutomationSetting> getAdGroupAdAssetAutomationSettingsList() {
        return this.adGroupAdAssetAutomationSettings_;
    }

    @Override
    public List<? extends AdGroupAdAssetAutomationSettingOrBuilder> getAdGroupAdAssetAutomationSettingsOrBuilderList() {
        return this.adGroupAdAssetAutomationSettings_;
    }

    @Override
    public int getAdGroupAdAssetAutomationSettingsCount() {
        return this.adGroupAdAssetAutomationSettings_.size();
    }

    @Override
    public AdGroupAdAssetAutomationSetting getAdGroupAdAssetAutomationSettings(int index) {
        return this.adGroupAdAssetAutomationSettings_.get(index);
    }

    @Override
    public AdGroupAdAssetAutomationSettingOrBuilder getAdGroupAdAssetAutomationSettingsOrBuilder(int index) {
        return this.adGroupAdAssetAutomationSettings_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.status_ != AdGroupAdStatusEnum.AdGroupAdStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.status_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(5, (MessageLite)this.getAd());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getPolicySummary());
        }
        if (this.adStrength_ != AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.adStrength_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.adGroup_);
        }
        for (i = 0; i < this.labels_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.labels_.getRaw(i));
        }
        for (i = 0; i < this.actionItems_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.actionItems_.getRaw(i));
        }
        if (this.primaryStatus_ != AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(16, this.primaryStatus_);
        }
        if (this.getPrimaryStatusReasonsList().size() > 0) {
            output.writeUInt32NoTag(138);
            output.writeUInt32NoTag(this.primaryStatusReasonsMemoizedSerializedSize);
        }
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            output.writeEnumNoTag(this.primaryStatusReasons_.get(i).intValue());
        }
        for (i = 0; i < this.adGroupAdAssetAutomationSettings_.size(); ++i) {
            output.writeMessage(18, (MessageLite)this.adGroupAdAssetAutomationSettings_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.status_ != AdGroupAdStatusEnum.AdGroupAdStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.status_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getAd());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getPolicySummary());
        }
        if (this.adStrength_ != AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.adStrength_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.adGroup_);
        }
        int dataSize = 0;
        for (i = 0; i < this.labels_.size(); ++i) {
            dataSize += AdGroupAd.computeStringSizeNoTag((Object)this.labels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getLabelsList().size();
        dataSize = 0;
        for (i = 0; i < this.actionItems_.size(); ++i) {
            dataSize += AdGroupAd.computeStringSizeNoTag((Object)this.actionItems_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getActionItemsList().size();
        if (this.primaryStatus_ != AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)16, (int)this.primaryStatus_);
        }
        dataSize = 0;
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.primaryStatusReasons_.get(i));
        }
        size += dataSize;
        if (!this.getPrimaryStatusReasonsList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.primaryStatusReasonsMemoizedSerializedSize = dataSize;
        for (int i2 = 0; i2 < this.adGroupAdAssetAutomationSettings_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)((MessageLite)this.adGroupAdAssetAutomationSettings_.get(i2)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdGroupAd)) {
            return super.equals(obj);
        }
        AdGroupAd other = (AdGroupAd)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.hasAdGroup() != other.hasAdGroup()) {
            return false;
        }
        if (this.hasAdGroup() && !this.getAdGroup().equals(other.getAdGroup())) {
            return false;
        }
        if (this.hasAd() != other.hasAd()) {
            return false;
        }
        if (this.hasAd() && !this.getAd().equals(other.getAd())) {
            return false;
        }
        if (this.hasPolicySummary() != other.hasPolicySummary()) {
            return false;
        }
        if (this.hasPolicySummary() && !this.getPolicySummary().equals(other.getPolicySummary())) {
            return false;
        }
        if (this.adStrength_ != other.adStrength_) {
            return false;
        }
        if (!this.getActionItemsList().equals(other.getActionItemsList())) {
            return false;
        }
        if (!this.getLabelsList().equals(other.getLabelsList())) {
            return false;
        }
        if (this.primaryStatus_ != other.primaryStatus_) {
            return false;
        }
        if (!this.primaryStatusReasons_.equals(other.primaryStatusReasons_)) {
            return false;
        }
        if (!this.getAdGroupAdAssetAutomationSettingsList().equals(other.getAdGroupAdAssetAutomationSettingsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AdGroupAd.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.status_;
        if (this.hasAdGroup()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAdGroup().hashCode();
        }
        if (this.hasAd()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getAd().hashCode();
        }
        if (this.hasPolicySummary()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPolicySummary().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.adStrength_;
        if (this.getActionItemsCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getActionItemsList().hashCode();
        }
        if (this.getLabelsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getLabelsList().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + this.primaryStatus_;
        if (this.getPrimaryStatusReasonsCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.primaryStatusReasons_.hashCode();
        }
        if (this.getAdGroupAdAssetAutomationSettingsCount() > 0) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getAdGroupAdAssetAutomationSettingsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AdGroupAd parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data);
    }

    public static AdGroupAd parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupAd parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data);
    }

    public static AdGroupAd parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupAd parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data);
    }

    public static AdGroupAd parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupAd)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupAd parseFrom(InputStream input) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroupAd parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroupAd parseDelimitedFrom(InputStream input) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroupAd parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroupAd parseFrom(CodedInputStream input) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AdGroupAd parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupAd)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AdGroupAd.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AdGroupAd prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AdGroupAd getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AdGroupAd> parser() {
        return PARSER;
    }

    public Parser<AdGroupAd> getParserForType() {
        return PARSER;
    }

    public AdGroupAd getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AdGroupAdOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private int status_ = 0;
        private Object adGroup_ = "";
        private Ad ad_;
        private SingleFieldBuilderV3<Ad, Ad.Builder, AdOrBuilder> adBuilder_;
        private AdGroupAdPolicySummary policySummary_;
        private SingleFieldBuilderV3<AdGroupAdPolicySummary, AdGroupAdPolicySummary.Builder, AdGroupAdPolicySummaryOrBuilder> policySummaryBuilder_;
        private int adStrength_ = 0;
        private LazyStringArrayList actionItems_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList labels_ = LazyStringArrayList.emptyList();
        private int primaryStatus_ = 0;
        private List<Integer> primaryStatusReasons_ = Collections.emptyList();
        private List<AdGroupAdAssetAutomationSetting> adGroupAdAssetAutomationSettings_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AdGroupAdAssetAutomationSetting, AdGroupAdAssetAutomationSetting.Builder, AdGroupAdAssetAutomationSettingOrBuilder> adGroupAdAssetAutomationSettingsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AdGroupAdProto.internal_static_google_ads_googleads_v21_resources_AdGroupAd_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AdGroupAdProto.internal_static_google_ads_googleads_v21_resources_AdGroupAd_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupAd.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAdFieldBuilder();
                this.getPolicySummaryFieldBuilder();
                this.getAdGroupAdAssetAutomationSettingsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.status_ = 0;
            this.adGroup_ = "";
            this.ad_ = null;
            if (this.adBuilder_ != null) {
                this.adBuilder_.dispose();
                this.adBuilder_ = null;
            }
            this.policySummary_ = null;
            if (this.policySummaryBuilder_ != null) {
                this.policySummaryBuilder_.dispose();
                this.policySummaryBuilder_ = null;
            }
            this.adStrength_ = 0;
            this.actionItems_ = LazyStringArrayList.emptyList();
            this.labels_ = LazyStringArrayList.emptyList();
            this.primaryStatus_ = 0;
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.adGroupAdAssetAutomationSettings_ = Collections.emptyList();
            } else {
                this.adGroupAdAssetAutomationSettings_ = null;
                this.adGroupAdAssetAutomationSettingsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AdGroupAdProto.internal_static_google_ads_googleads_v21_resources_AdGroupAd_descriptor;
        }

        public AdGroupAd getDefaultInstanceForType() {
            return AdGroupAd.getDefaultInstance();
        }

        public AdGroupAd build() {
            AdGroupAd result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AdGroupAd buildPartial() {
            AdGroupAd result = new AdGroupAd(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AdGroupAd result) {
            if ((this.bitField0_ & 0x200) != 0) {
                this.primaryStatusReasons_ = Collections.unmodifiableList(this.primaryStatusReasons_);
                this.bitField0_ &= 0xFFFFFDFF;
            }
            result.primaryStatusReasons_ = this.primaryStatusReasons_;
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.adGroupAdAssetAutomationSettings_ = Collections.unmodifiableList(this.adGroupAdAssetAutomationSettings_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.adGroupAdAssetAutomationSettings_ = this.adGroupAdAssetAutomationSettings_;
            } else {
                result.adGroupAdAssetAutomationSettings_ = this.adGroupAdAssetAutomationSettingsBuilder_.build();
            }
        }

        private void buildPartial0(AdGroupAd result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.status_ = this.status_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.adGroup_ = this.adGroup_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.ad_ = this.adBuilder_ == null ? this.ad_ : (Ad)this.adBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.policySummary_ = this.policySummaryBuilder_ == null ? this.policySummary_ : (AdGroupAdPolicySummary)this.policySummaryBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.adStrength_ = this.adStrength_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                this.actionItems_.makeImmutable();
                result.actionItems_ = this.actionItems_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.labels_.makeImmutable();
                result.labels_ = this.labels_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.primaryStatus_ = this.primaryStatus_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AdGroupAd) {
                return this.mergeFrom((AdGroupAd)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AdGroupAd other) {
            if (other == AdGroupAd.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.hasAdGroup()) {
                this.adGroup_ = other.adGroup_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.hasAd()) {
                this.mergeAd(other.getAd());
            }
            if (other.hasPolicySummary()) {
                this.mergePolicySummary(other.getPolicySummary());
            }
            if (other.adStrength_ != 0) {
                this.setAdStrengthValue(other.getAdStrengthValue());
            }
            if (!other.actionItems_.isEmpty()) {
                if (this.actionItems_.isEmpty()) {
                    this.actionItems_ = other.actionItems_;
                    this.bitField0_ |= 0x40;
                } else {
                    this.ensureActionItemsIsMutable();
                    this.actionItems_.addAll((Collection)other.actionItems_);
                }
                this.onChanged();
            }
            if (!other.labels_.isEmpty()) {
                if (this.labels_.isEmpty()) {
                    this.labels_ = other.labels_;
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureLabelsIsMutable();
                    this.labels_.addAll((Collection)other.labels_);
                }
                this.onChanged();
            }
            if (other.primaryStatus_ != 0) {
                this.setPrimaryStatusValue(other.getPrimaryStatusValue());
            }
            if (!other.primaryStatusReasons_.isEmpty()) {
                if (this.primaryStatusReasons_.isEmpty()) {
                    this.primaryStatusReasons_ = other.primaryStatusReasons_;
                    this.bitField0_ &= 0xFFFFFDFF;
                } else {
                    this.ensurePrimaryStatusReasonsIsMutable();
                    this.primaryStatusReasons_.addAll(other.primaryStatusReasons_);
                }
                this.onChanged();
            }
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                if (!other.adGroupAdAssetAutomationSettings_.isEmpty()) {
                    if (this.adGroupAdAssetAutomationSettings_.isEmpty()) {
                        this.adGroupAdAssetAutomationSettings_ = other.adGroupAdAssetAutomationSettings_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                        this.adGroupAdAssetAutomationSettings_.addAll(other.adGroupAdAssetAutomationSettings_);
                    }
                    this.onChanged();
                }
            } else if (!other.adGroupAdAssetAutomationSettings_.isEmpty()) {
                if (this.adGroupAdAssetAutomationSettingsBuilder_.isEmpty()) {
                    this.adGroupAdAssetAutomationSettingsBuilder_.dispose();
                    this.adGroupAdAssetAutomationSettingsBuilder_ = null;
                    this.adGroupAdAssetAutomationSettings_ = other.adGroupAdAssetAutomationSettings_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.adGroupAdAssetAutomationSettingsBuilder_ = alwaysUseFieldBuilders ? this.getAdGroupAdAssetAutomationSettingsFieldBuilder() : null;
                } else {
                    this.adGroupAdAssetAutomationSettingsBuilder_.addAllMessages((Iterable)other.adGroupAdAssetAutomationSettings_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 24: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getAdFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getPolicySummaryFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 56: {
                            this.adStrength_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block20;
                        }
                        case 74: {
                            this.adGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 82: {
                            String s = input.readStringRequireUtf8();
                            this.ensureLabelsIsMutable();
                            this.labels_.add((Object)s);
                            continue block20;
                        }
                        case 106: {
                            String s = input.readStringRequireUtf8();
                            this.ensureActionItemsIsMutable();
                            this.actionItems_.add((Object)s);
                            continue block20;
                        }
                        case 128: {
                            this.primaryStatus_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 136: {
                            int tmpRaw = input.readEnum();
                            this.ensurePrimaryStatusReasonsIsMutable();
                            this.primaryStatusReasons_.add(tmpRaw);
                            continue block20;
                        }
                        case 138: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePrimaryStatusReasonsIsMutable();
                                this.primaryStatusReasons_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block20;
                        }
                        case 146: {
                            AdGroupAdAssetAutomationSetting m = (AdGroupAdAssetAutomationSetting)input.readMessage(AdGroupAdAssetAutomationSetting.parser(), extensionRegistry);
                            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                                this.adGroupAdAssetAutomationSettings_.add(m);
                                continue block20;
                            }
                            this.adGroupAdAssetAutomationSettingsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AdGroupAd.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupAd.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public AdGroupAdStatusEnum.AdGroupAdStatus getStatus() {
            AdGroupAdStatusEnum.AdGroupAdStatus result = AdGroupAdStatusEnum.AdGroupAdStatus.forNumber(this.status_);
            return result == null ? AdGroupAdStatusEnum.AdGroupAdStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AdGroupAdStatusEnum.AdGroupAdStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAdGroup() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getAdGroup() {
            Object ref = this.adGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.adGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAdGroupBytes() {
            Object ref = this.adGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.adGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAdGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.adGroup_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearAdGroup() {
            this.adGroup_ = AdGroupAd.getDefaultInstance().getAdGroup();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setAdGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupAd.checkByteStringIsUtf8((ByteString)value);
            this.adGroup_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAd() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Ad getAd() {
            if (this.adBuilder_ == null) {
                return this.ad_ == null ? Ad.getDefaultInstance() : this.ad_;
            }
            return (Ad)this.adBuilder_.getMessage();
        }

        public Builder setAd(Ad value) {
            if (this.adBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ad_ = value;
            } else {
                this.adBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setAd(Ad.Builder builderForValue) {
            if (this.adBuilder_ == null) {
                this.ad_ = builderForValue.build();
            } else {
                this.adBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeAd(Ad value) {
            if (this.adBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.ad_ != null && this.ad_ != Ad.getDefaultInstance()) {
                    this.getAdBuilder().mergeFrom(value);
                } else {
                    this.ad_ = value;
                }
            } else {
                this.adBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.ad_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAd() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.ad_ = null;
            if (this.adBuilder_ != null) {
                this.adBuilder_.dispose();
                this.adBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Ad.Builder getAdBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Ad.Builder)this.getAdFieldBuilder().getBuilder();
        }

        @Override
        public AdOrBuilder getAdOrBuilder() {
            if (this.adBuilder_ != null) {
                return (AdOrBuilder)this.adBuilder_.getMessageOrBuilder();
            }
            return this.ad_ == null ? Ad.getDefaultInstance() : this.ad_;
        }

        private SingleFieldBuilderV3<Ad, Ad.Builder, AdOrBuilder> getAdFieldBuilder() {
            if (this.adBuilder_ == null) {
                this.adBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAd(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.ad_ = null;
            }
            return this.adBuilder_;
        }

        @Override
        public boolean hasPolicySummary() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public AdGroupAdPolicySummary getPolicySummary() {
            if (this.policySummaryBuilder_ == null) {
                return this.policySummary_ == null ? AdGroupAdPolicySummary.getDefaultInstance() : this.policySummary_;
            }
            return (AdGroupAdPolicySummary)this.policySummaryBuilder_.getMessage();
        }

        public Builder setPolicySummary(AdGroupAdPolicySummary value) {
            if (this.policySummaryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.policySummary_ = value;
            } else {
                this.policySummaryBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setPolicySummary(AdGroupAdPolicySummary.Builder builderForValue) {
            if (this.policySummaryBuilder_ == null) {
                this.policySummary_ = builderForValue.build();
            } else {
                this.policySummaryBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergePolicySummary(AdGroupAdPolicySummary value) {
            if (this.policySummaryBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.policySummary_ != null && this.policySummary_ != AdGroupAdPolicySummary.getDefaultInstance()) {
                    this.getPolicySummaryBuilder().mergeFrom(value);
                } else {
                    this.policySummary_ = value;
                }
            } else {
                this.policySummaryBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.policySummary_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPolicySummary() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.policySummary_ = null;
            if (this.policySummaryBuilder_ != null) {
                this.policySummaryBuilder_.dispose();
                this.policySummaryBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AdGroupAdPolicySummary.Builder getPolicySummaryBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (AdGroupAdPolicySummary.Builder)this.getPolicySummaryFieldBuilder().getBuilder();
        }

        @Override
        public AdGroupAdPolicySummaryOrBuilder getPolicySummaryOrBuilder() {
            if (this.policySummaryBuilder_ != null) {
                return (AdGroupAdPolicySummaryOrBuilder)this.policySummaryBuilder_.getMessageOrBuilder();
            }
            return this.policySummary_ == null ? AdGroupAdPolicySummary.getDefaultInstance() : this.policySummary_;
        }

        private SingleFieldBuilderV3<AdGroupAdPolicySummary, AdGroupAdPolicySummary.Builder, AdGroupAdPolicySummaryOrBuilder> getPolicySummaryFieldBuilder() {
            if (this.policySummaryBuilder_ == null) {
                this.policySummaryBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPolicySummary(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.policySummary_ = null;
            }
            return this.policySummaryBuilder_;
        }

        @Override
        public int getAdStrengthValue() {
            return this.adStrength_;
        }

        public Builder setAdStrengthValue(int value) {
            this.adStrength_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public AdStrengthEnum.AdStrength getAdStrength() {
            AdStrengthEnum.AdStrength result = AdStrengthEnum.AdStrength.forNumber(this.adStrength_);
            return result == null ? AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
        }

        public Builder setAdStrength(AdStrengthEnum.AdStrength value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.adStrength_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdStrength() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.adStrength_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureActionItemsIsMutable() {
            if (!this.actionItems_.isModifiable()) {
                this.actionItems_ = new LazyStringArrayList((LazyStringList)this.actionItems_);
            }
            this.bitField0_ |= 0x40;
        }

        public ProtocolStringList getActionItemsList() {
            this.actionItems_.makeImmutable();
            return this.actionItems_;
        }

        @Override
        public int getActionItemsCount() {
            return this.actionItems_.size();
        }

        @Override
        public String getActionItems(int index) {
            return this.actionItems_.get(index);
        }

        @Override
        public ByteString getActionItemsBytes(int index) {
            return this.actionItems_.getByteString(index);
        }

        public Builder setActionItems(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureActionItemsIsMutable();
            this.actionItems_.set(index, value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addActionItems(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureActionItemsIsMutable();
            this.actionItems_.add((Object)value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addAllActionItems(Iterable<String> values) {
            this.ensureActionItemsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.actionItems_);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearActionItems() {
            this.actionItems_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder addActionItemsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupAd.checkByteStringIsUtf8((ByteString)value);
            this.ensureActionItemsIsMutable();
            this.actionItems_.add(value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private void ensureLabelsIsMutable() {
            if (!this.labels_.isModifiable()) {
                this.labels_ = new LazyStringArrayList((LazyStringList)this.labels_);
            }
            this.bitField0_ |= 0x80;
        }

        public ProtocolStringList getLabelsList() {
            this.labels_.makeImmutable();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.labels_.size();
        }

        @Override
        public String getLabels(int index) {
            return this.labels_.get(index);
        }

        @Override
        public ByteString getLabelsBytes(int index) {
            return this.labels_.getByteString(index);
        }

        public Builder setLabels(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLabelsIsMutable();
            this.labels_.set(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addLabels(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLabelsIsMutable();
            this.labels_.add((Object)value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllLabels(Iterable<String> values) {
            this.ensureLabelsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.labels_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearLabels() {
            this.labels_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addLabelsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupAd.checkByteStringIsUtf8((ByteString)value);
            this.ensureLabelsIsMutable();
            this.labels_.add(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public int getPrimaryStatusValue() {
            return this.primaryStatus_;
        }

        public Builder setPrimaryStatusValue(int value) {
            this.primaryStatus_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus getPrimaryStatus() {
            AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus result = AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.forNumber(this.primaryStatus_);
            return result == null ? AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus.UNRECOGNIZED : result;
        }

        public Builder setPrimaryStatus(AdGroupAdPrimaryStatusEnum.AdGroupAdPrimaryStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.primaryStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatus() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.primaryStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePrimaryStatusReasonsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.primaryStatusReasons_ = new ArrayList<Integer>(this.primaryStatusReasons_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason> getPrimaryStatusReasonsList() {
            return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
        }

        @Override
        public int getPrimaryStatusReasonsCount() {
            return this.primaryStatusReasons_.size();
        }

        @Override
        public AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason getPrimaryStatusReasons(int index) {
            return (AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
        }

        public Builder setPrimaryStatusReasons(int index, AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasons(AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasons(Iterable<? extends AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (AdGroupAdPrimaryStatusReasonEnum.AdGroupAdPrimaryStatusReason adGroupAdPrimaryStatusReason : values) {
                this.primaryStatusReasons_.add(adGroupAdPrimaryStatusReason.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatusReasons() {
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPrimaryStatusReasonsValueList() {
            return Collections.unmodifiableList(this.primaryStatusReasons_);
        }

        @Override
        public int getPrimaryStatusReasonsValue(int index) {
            return this.primaryStatusReasons_.get(index);
        }

        public Builder setPrimaryStatusReasonsValue(int index, int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasonsValue(int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasonsValue(Iterable<Integer> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (int value : values) {
                this.primaryStatusReasons_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureAdGroupAdAssetAutomationSettingsIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.adGroupAdAssetAutomationSettings_ = new ArrayList<AdGroupAdAssetAutomationSetting>(this.adGroupAdAssetAutomationSettings_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<AdGroupAdAssetAutomationSetting> getAdGroupAdAssetAutomationSettingsList() {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                return Collections.unmodifiableList(this.adGroupAdAssetAutomationSettings_);
            }
            return this.adGroupAdAssetAutomationSettingsBuilder_.getMessageList();
        }

        @Override
        public int getAdGroupAdAssetAutomationSettingsCount() {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                return this.adGroupAdAssetAutomationSettings_.size();
            }
            return this.adGroupAdAssetAutomationSettingsBuilder_.getCount();
        }

        @Override
        public AdGroupAdAssetAutomationSetting getAdGroupAdAssetAutomationSettings(int index) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                return this.adGroupAdAssetAutomationSettings_.get(index);
            }
            return (AdGroupAdAssetAutomationSetting)this.adGroupAdAssetAutomationSettingsBuilder_.getMessage(index);
        }

        public Builder setAdGroupAdAssetAutomationSettings(int index, AdGroupAdAssetAutomationSetting value) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.set(index, value);
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdGroupAdAssetAutomationSettings(int index, AdGroupAdAssetAutomationSetting.Builder builderForValue) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupAdAssetAutomationSettings(AdGroupAdAssetAutomationSetting value) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.add(value);
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupAdAssetAutomationSettings(int index, AdGroupAdAssetAutomationSetting value) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.add(index, value);
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdGroupAdAssetAutomationSettings(AdGroupAdAssetAutomationSetting.Builder builderForValue) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdGroupAdAssetAutomationSettings(int index, AdGroupAdAssetAutomationSetting.Builder builderForValue) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdGroupAdAssetAutomationSettings(Iterable<? extends AdGroupAdAssetAutomationSetting> values) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.adGroupAdAssetAutomationSettings_);
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdGroupAdAssetAutomationSettings() {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.adGroupAdAssetAutomationSettings_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdGroupAdAssetAutomationSettings(int index) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.ensureAdGroupAdAssetAutomationSettingsIsMutable();
                this.adGroupAdAssetAutomationSettings_.remove(index);
                this.onChanged();
            } else {
                this.adGroupAdAssetAutomationSettingsBuilder_.remove(index);
            }
            return this;
        }

        public AdGroupAdAssetAutomationSetting.Builder getAdGroupAdAssetAutomationSettingsBuilder(int index) {
            return (AdGroupAdAssetAutomationSetting.Builder)this.getAdGroupAdAssetAutomationSettingsFieldBuilder().getBuilder(index);
        }

        @Override
        public AdGroupAdAssetAutomationSettingOrBuilder getAdGroupAdAssetAutomationSettingsOrBuilder(int index) {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                return this.adGroupAdAssetAutomationSettings_.get(index);
            }
            return (AdGroupAdAssetAutomationSettingOrBuilder)this.adGroupAdAssetAutomationSettingsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AdGroupAdAssetAutomationSettingOrBuilder> getAdGroupAdAssetAutomationSettingsOrBuilderList() {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ != null) {
                return this.adGroupAdAssetAutomationSettingsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.adGroupAdAssetAutomationSettings_);
        }

        public AdGroupAdAssetAutomationSetting.Builder addAdGroupAdAssetAutomationSettingsBuilder() {
            return (AdGroupAdAssetAutomationSetting.Builder)this.getAdGroupAdAssetAutomationSettingsFieldBuilder().addBuilder((AbstractMessage)AdGroupAdAssetAutomationSetting.getDefaultInstance());
        }

        public AdGroupAdAssetAutomationSetting.Builder addAdGroupAdAssetAutomationSettingsBuilder(int index) {
            return (AdGroupAdAssetAutomationSetting.Builder)this.getAdGroupAdAssetAutomationSettingsFieldBuilder().addBuilder(index, (AbstractMessage)AdGroupAdAssetAutomationSetting.getDefaultInstance());
        }

        public List<AdGroupAdAssetAutomationSetting.Builder> getAdGroupAdAssetAutomationSettingsBuilderList() {
            return this.getAdGroupAdAssetAutomationSettingsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AdGroupAdAssetAutomationSetting, AdGroupAdAssetAutomationSetting.Builder, AdGroupAdAssetAutomationSettingOrBuilder> getAdGroupAdAssetAutomationSettingsFieldBuilder() {
            if (this.adGroupAdAssetAutomationSettingsBuilder_ == null) {
                this.adGroupAdAssetAutomationSettingsBuilder_ = new RepeatedFieldBuilderV3(this.adGroupAdAssetAutomationSettings_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adGroupAdAssetAutomationSettings_ = null;
            }
            return this.adGroupAdAssetAutomationSettingsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

