/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HotelReconciliationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_COMMISSION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/hotelReconciliations/{commission_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String commissionId;

    @Deprecated
    protected HotelReconciliationName() {
        this.customerId = null;
        this.commissionId = null;
    }

    private HotelReconciliationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.commissionId = (String)Preconditions.checkNotNull((Object)builder.getCommissionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCommissionId() {
        return this.commissionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HotelReconciliationName of(String customerId, String commissionId) {
        return HotelReconciliationName.newBuilder().setCustomerId(customerId).setCommissionId(commissionId).build();
    }

    public static String format(String customerId, String commissionId) {
        return HotelReconciliationName.newBuilder().setCustomerId(customerId).setCommissionId(commissionId).build().toString();
    }

    public static HotelReconciliationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_COMMISSION_ID.validatedMatch(formattedString, "HotelReconciliationName.parse: formattedString not in valid format");
        return HotelReconciliationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("commission_id"));
    }

    public static List<HotelReconciliationName> parseList(List<String> formattedStrings) {
        ArrayList<HotelReconciliationName> list = new ArrayList<HotelReconciliationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HotelReconciliationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HotelReconciliationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HotelReconciliationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_COMMISSION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HotelReconciliationName hotelReconciliationName = this;
            synchronized (hotelReconciliationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.commissionId != null) {
                        fieldMapBuilder.put((Object)"commission_id", (Object)this.commissionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_COMMISSION_ID.instantiate(new String[]{"customer_id", this.customerId, "commission_id", this.commissionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HotelReconciliationName that = (HotelReconciliationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.commissionId, that.commissionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.commissionId);
    }

    public static class Builder {
        private String customerId;
        private String commissionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCommissionId() {
            return this.commissionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCommissionId(String commissionId) {
            this.commissionId = commissionId;
            return this;
        }

        private Builder(HotelReconciliationName hotelReconciliationName) {
            this.customerId = hotelReconciliationName.customerId;
            this.commissionId = hotelReconciliationName.commissionId;
        }

        public HotelReconciliationName build() {
            return new HotelReconciliationName(this);
        }
    }
}

