/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchTermViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_QUERY = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/searchTermViews/{campaign_id}~{ad_group_id}~{query}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String adGroupId;
    private final String query;

    @Deprecated
    protected SearchTermViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.adGroupId = null;
        this.query = null;
    }

    private SearchTermViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.query = (String)Preconditions.checkNotNull((Object)builder.getQuery());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getQuery() {
        return this.query;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SearchTermViewName of(String customerId, String campaignId, String adGroupId, String query) {
        return SearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setQuery(query).build();
    }

    public static String format(String customerId, String campaignId, String adGroupId, String query) {
        return SearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setQuery(query).build().toString();
    }

    public static SearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_QUERY.validatedMatch(formattedString, "SearchTermViewName.parse: formattedString not in valid format");
        return SearchTermViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("query"));
    }

    public static List<SearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<SearchTermViewName> list = new ArrayList<SearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_QUERY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SearchTermViewName searchTermViewName = this;
            synchronized (searchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.query != null) {
                        fieldMapBuilder.put((Object)"query", (Object)this.query);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_QUERY.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "ad_group_id", this.adGroupId, "query", this.query});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SearchTermViewName that = (SearchTermViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.query, that.query);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.query);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String adGroupId;
        private String query;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getQuery() {
            return this.query;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        private Builder(SearchTermViewName searchTermViewName) {
            this.customerId = searchTermViewName.customerId;
            this.campaignId = searchTermViewName.campaignId;
            this.adGroupId = searchTermViewName.adGroupId;
            this.query = searchTermViewName.query;
        }

        public SearchTermViewName build() {
            return new SearchTermViewName(this);
        }
    }
}

