/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services;

import com.google.ads.googleads.v21.resources.AdGroupAdName;
import com.google.ads.googleads.v21.services.AdGroupAdOperation;
import com.google.ads.googleads.v21.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v21.services.AssetsWithFieldType;
import com.google.ads.googleads.v21.services.MutateAdGroupAdsRequest;
import com.google.ads.googleads.v21.services.MutateAdGroupAdsResponse;
import com.google.ads.googleads.v21.services.RemoveAutomaticallyCreatedAssetsRequest;
import com.google.ads.googleads.v21.services.stub.AdGroupAdServiceStub;
import com.google.ads.googleads.v21.services.stub.AdGroupAdServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupAdServiceClient
implements BackgroundResource {
    private final AdGroupAdServiceSettings settings;
    private final AdGroupAdServiceStub stub;

    public static final AdGroupAdServiceClient create() throws IOException {
        return AdGroupAdServiceClient.create(AdGroupAdServiceSettings.newBuilder().build());
    }

    public static final AdGroupAdServiceClient create(AdGroupAdServiceSettings settings) throws IOException {
        return new AdGroupAdServiceClient(settings);
    }

    public static final AdGroupAdServiceClient create(AdGroupAdServiceStub stub) {
        return new AdGroupAdServiceClient(stub);
    }

    protected AdGroupAdServiceClient(AdGroupAdServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupAdServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupAdServiceClient(AdGroupAdServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupAdServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupAdServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupAdsResponse mutateAdGroupAds(String customerId, List<AdGroupAdOperation> operations) {
        MutateAdGroupAdsRequest request = MutateAdGroupAdsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupAds(request);
    }

    public final MutateAdGroupAdsResponse mutateAdGroupAds(MutateAdGroupAdsRequest request) {
        return (MutateAdGroupAdsResponse)this.mutateAdGroupAdsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupAdsRequest, MutateAdGroupAdsResponse> mutateAdGroupAdsCallable() {
        return this.stub.mutateAdGroupAdsCallable();
    }

    public final void removeAutomaticallyCreatedAssets(AdGroupAdName adGroupAd, List<AssetsWithFieldType> assetsWithFieldType) {
        RemoveAutomaticallyCreatedAssetsRequest request = RemoveAutomaticallyCreatedAssetsRequest.newBuilder().setAdGroupAd(adGroupAd == null ? null : adGroupAd.toString()).addAllAssetsWithFieldType(assetsWithFieldType).build();
        this.removeAutomaticallyCreatedAssets(request);
    }

    public final void removeAutomaticallyCreatedAssets(String adGroupAd, List<AssetsWithFieldType> assetsWithFieldType) {
        RemoveAutomaticallyCreatedAssetsRequest request = RemoveAutomaticallyCreatedAssetsRequest.newBuilder().setAdGroupAd(adGroupAd).addAllAssetsWithFieldType(assetsWithFieldType).build();
        this.removeAutomaticallyCreatedAssets(request);
    }

    public final void removeAutomaticallyCreatedAssets(RemoveAutomaticallyCreatedAssetsRequest request) {
        this.removeAutomaticallyCreatedAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveAutomaticallyCreatedAssetsRequest, Empty> removeAutomaticallyCreatedAssetsCallable() {
        return this.stub.removeAutomaticallyCreatedAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

