/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services;

import com.google.ads.googleads.v21.services.MutateUserListsRequest;
import com.google.ads.googleads.v21.services.MutateUserListsResponse;
import com.google.ads.googleads.v21.services.UserListOperation;
import com.google.ads.googleads.v21.services.UserListServiceSettings;
import com.google.ads.googleads.v21.services.stub.UserListServiceStub;
import com.google.ads.googleads.v21.services.stub.UserListServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class UserListServiceClient
implements BackgroundResource {
    private final UserListServiceSettings settings;
    private final UserListServiceStub stub;

    public static final UserListServiceClient create() throws IOException {
        return UserListServiceClient.create(UserListServiceSettings.newBuilder().build());
    }

    public static final UserListServiceClient create(UserListServiceSettings settings) throws IOException {
        return new UserListServiceClient(settings);
    }

    public static final UserListServiceClient create(UserListServiceStub stub) {
        return new UserListServiceClient(stub);
    }

    protected UserListServiceClient(UserListServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserListServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected UserListServiceClient(UserListServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UserListServiceSettings getSettings() {
        return this.settings;
    }

    public UserListServiceStub getStub() {
        return this.stub;
    }

    public final MutateUserListsResponse mutateUserLists(String customerId, List<UserListOperation> operations) {
        MutateUserListsRequest request = MutateUserListsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateUserLists(request);
    }

    public final MutateUserListsResponse mutateUserLists(MutateUserListsRequest request) {
        return (MutateUserListsResponse)this.mutateUserListsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateUserListsRequest, MutateUserListsResponse> mutateUserListsCallable() {
        return this.stub.mutateUserListsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

