/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.resources.BatchJob;
import com.google.ads.googleads.v21.services.AddBatchJobOperationsRequest;
import com.google.ads.googleads.v21.services.AddBatchJobOperationsResponse;
import com.google.ads.googleads.v21.services.BatchJobServiceClient;
import com.google.ads.googleads.v21.services.ListBatchJobResultsRequest;
import com.google.ads.googleads.v21.services.ListBatchJobResultsResponse;
import com.google.ads.googleads.v21.services.MutateBatchJobRequest;
import com.google.ads.googleads.v21.services.MutateBatchJobResponse;
import com.google.ads.googleads.v21.services.RunBatchJobRequest;
import com.google.ads.googleads.v21.services.stub.BatchJobServiceStub;
import com.google.ads.googleads.v21.services.stub.BatchJobServiceStubSettings;
import com.google.ads.googleads.v21.services.stub.GrpcBatchJobServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBatchJobServiceStub
extends BatchJobServiceStub {
    private static final MethodDescriptor<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.BatchJobService/MutateBatchJob").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateBatchJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateBatchJobResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBatchJobResultsRequest, ListBatchJobResultsResponse> listBatchJobResultsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.BatchJobService/ListBatchJobResults").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBatchJobResultsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBatchJobResultsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RunBatchJobRequest, Operation> runBatchJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.BatchJobService/RunBatchJob").setRequestMarshaller(ProtoUtils.marshaller((Message)RunBatchJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.BatchJobService/AddBatchJobOperations").setRequestMarshaller(ProtoUtils.marshaller((Message)AddBatchJobOperationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AddBatchJobOperationsResponse.getDefaultInstance())).build();
    private final UnaryCallable<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobCallable;
    private final UnaryCallable<ListBatchJobResultsRequest, ListBatchJobResultsResponse> listBatchJobResultsCallable;
    private final UnaryCallable<ListBatchJobResultsRequest, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsPagedCallable;
    private final UnaryCallable<RunBatchJobRequest, Operation> runBatchJobCallable;
    private final OperationCallable<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationCallable;
    private final UnaryCallable<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBatchJobServiceStub create(BatchJobServiceStubSettings settings) throws IOException {
        return new GrpcBatchJobServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBatchJobServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBatchJobServiceStub(BatchJobServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBatchJobServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBatchJobServiceStub(BatchJobServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBatchJobServiceStub(BatchJobServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcBatchJobServiceCallableFactory());
    }

    protected GrpcBatchJobServiceStub(BatchJobServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateBatchJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateBatchJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings listBatchJobResultsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBatchJobResultsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        GrpcCallSettings runBatchJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runBatchJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        GrpcCallSettings addBatchJobOperationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addBatchJobOperationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        this.mutateBatchJobCallable = callableFactory.createUnaryCallable(mutateBatchJobTransportSettings, settings.mutateBatchJobSettings(), clientContext);
        this.listBatchJobResultsCallable = callableFactory.createUnaryCallable(listBatchJobResultsTransportSettings, settings.listBatchJobResultsSettings(), clientContext);
        this.listBatchJobResultsPagedCallable = callableFactory.createPagedCallable(listBatchJobResultsTransportSettings, settings.listBatchJobResultsSettings(), clientContext);
        this.runBatchJobCallable = callableFactory.createUnaryCallable(runBatchJobTransportSettings, settings.runBatchJobSettings(), clientContext);
        this.runBatchJobOperationCallable = callableFactory.createOperationCallable(runBatchJobTransportSettings, settings.runBatchJobOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.addBatchJobOperationsCallable = callableFactory.createUnaryCallable(addBatchJobOperationsTransportSettings, settings.addBatchJobOperationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobCallable() {
        return this.mutateBatchJobCallable;
    }

    @Override
    public UnaryCallable<ListBatchJobResultsRequest, ListBatchJobResultsResponse> listBatchJobResultsCallable() {
        return this.listBatchJobResultsCallable;
    }

    @Override
    public UnaryCallable<ListBatchJobResultsRequest, BatchJobServiceClient.ListBatchJobResultsPagedResponse> listBatchJobResultsPagedCallable() {
        return this.listBatchJobResultsPagedCallable;
    }

    @Override
    public UnaryCallable<RunBatchJobRequest, Operation> runBatchJobCallable() {
        return this.runBatchJobCallable;
    }

    @Override
    public OperationCallable<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationCallable() {
        return this.runBatchJobOperationCallable;
    }

    @Override
    public UnaryCallable<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsCallable() {
        return this.addBatchJobOperationsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

