/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.services.CreateCustomerClientRequest;
import com.google.ads.googleads.v21.services.CreateCustomerClientResponse;
import com.google.ads.googleads.v21.services.ListAccessibleCustomersRequest;
import com.google.ads.googleads.v21.services.ListAccessibleCustomersResponse;
import com.google.ads.googleads.v21.services.MutateCustomerRequest;
import com.google.ads.googleads.v21.services.MutateCustomerResponse;
import com.google.ads.googleads.v21.services.stub.CustomerServiceStub;
import com.google.ads.googleads.v21.services.stub.CustomerServiceStubSettings;
import com.google.ads.googleads.v21.services.stub.GrpcCustomerServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCustomerServiceStub
extends CustomerServiceStub {
    private static final MethodDescriptor<MutateCustomerRequest, MutateCustomerResponse> mutateCustomerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.CustomerService/MutateCustomer").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomerResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAccessibleCustomersRequest, ListAccessibleCustomersResponse> listAccessibleCustomersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.CustomerService/ListAccessibleCustomers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAccessibleCustomersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAccessibleCustomersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateCustomerClientRequest, CreateCustomerClientResponse> createCustomerClientMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.CustomerService/CreateCustomerClient").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCustomerClientRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateCustomerClientResponse.getDefaultInstance())).build();
    private final UnaryCallable<MutateCustomerRequest, MutateCustomerResponse> mutateCustomerCallable;
    private final UnaryCallable<ListAccessibleCustomersRequest, ListAccessibleCustomersResponse> listAccessibleCustomersCallable;
    private final UnaryCallable<CreateCustomerClientRequest, CreateCustomerClientResponse> createCustomerClientCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomerServiceStub create(CustomerServiceStubSettings settings) throws IOException {
        return new GrpcCustomerServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomerServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomerServiceStub(CustomerServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomerServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomerServiceStub(CustomerServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomerServiceStub(CustomerServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcCustomerServiceCallableFactory());
    }

    protected GrpcCustomerServiceStub(CustomerServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateCustomerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomerMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings listAccessibleCustomersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAccessibleCustomersMethodDescriptor).build();
        GrpcCallSettings createCustomerClientTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCustomerClientMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.mutateCustomerCallable = callableFactory.createUnaryCallable(mutateCustomerTransportSettings, settings.mutateCustomerSettings(), clientContext);
        this.listAccessibleCustomersCallable = callableFactory.createUnaryCallable(listAccessibleCustomersTransportSettings, settings.listAccessibleCustomersSettings(), clientContext);
        this.createCustomerClientCallable = callableFactory.createUnaryCallable(createCustomerClientTransportSettings, settings.createCustomerClientSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateCustomerRequest, MutateCustomerResponse> mutateCustomerCallable() {
        return this.mutateCustomerCallable;
    }

    @Override
    public UnaryCallable<ListAccessibleCustomersRequest, ListAccessibleCustomersResponse> listAccessibleCustomersCallable() {
        return this.listAccessibleCustomersCallable;
    }

    @Override
    public UnaryCallable<CreateCustomerClientRequest, CreateCustomerClientResponse> createCustomerClientCallable() {
        return this.createCustomerClientCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

