/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.resources.GoogleAdsField;
import com.google.ads.googleads.v21.services.GetGoogleAdsFieldRequest;
import com.google.ads.googleads.v21.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v21.services.SearchGoogleAdsFieldsRequest;
import com.google.ads.googleads.v21.services.SearchGoogleAdsFieldsResponse;
import com.google.ads.googleads.v21.services.stub.GoogleAdsFieldServiceStub;
import com.google.ads.googleads.v21.services.stub.GoogleAdsFieldServiceStubSettings;
import com.google.ads.googleads.v21.services.stub.GrpcGoogleAdsFieldServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcGoogleAdsFieldServiceStub
extends GoogleAdsFieldServiceStub {
    private static final MethodDescriptor<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.GoogleAdsFieldService/GetGoogleAdsField").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGoogleAdsFieldRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GoogleAdsField.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse> searchGoogleAdsFieldsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.GoogleAdsFieldService/SearchGoogleAdsFields").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsFieldsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchGoogleAdsFieldsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldCallable;
    private final UnaryCallable<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse> searchGoogleAdsFieldsCallable;
    private final UnaryCallable<SearchGoogleAdsFieldsRequest, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGoogleAdsFieldServiceStub create(GoogleAdsFieldServiceStubSettings settings) throws IOException {
        return new GrpcGoogleAdsFieldServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGoogleAdsFieldServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGoogleAdsFieldServiceStub(GoogleAdsFieldServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGoogleAdsFieldServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGoogleAdsFieldServiceStub(GoogleAdsFieldServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGoogleAdsFieldServiceStub(GoogleAdsFieldServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcGoogleAdsFieldServiceCallableFactory());
    }

    protected GrpcGoogleAdsFieldServiceStub(GoogleAdsFieldServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getGoogleAdsFieldTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGoogleAdsFieldMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_name", String.valueOf(request.getResourceName()));
            return builder.build();
        }).build();
        GrpcCallSettings searchGoogleAdsFieldsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchGoogleAdsFieldsMethodDescriptor).build();
        this.getGoogleAdsFieldCallable = callableFactory.createUnaryCallable(getGoogleAdsFieldTransportSettings, settings.getGoogleAdsFieldSettings(), clientContext);
        this.searchGoogleAdsFieldsCallable = callableFactory.createUnaryCallable(searchGoogleAdsFieldsTransportSettings, settings.searchGoogleAdsFieldsSettings(), clientContext);
        this.searchGoogleAdsFieldsPagedCallable = callableFactory.createPagedCallable(searchGoogleAdsFieldsTransportSettings, settings.searchGoogleAdsFieldsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldCallable() {
        return this.getGoogleAdsFieldCallable;
    }

    @Override
    public UnaryCallable<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse> searchGoogleAdsFieldsCallable() {
        return this.searchGoogleAdsFieldsCallable;
    }

    @Override
    public UnaryCallable<SearchGoogleAdsFieldsRequest, GoogleAdsFieldServiceClient.SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsPagedCallable() {
        return this.searchGoogleAdsFieldsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

