/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignAggregateAssetViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_ASSET_LINK_SOURCE_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignAggregateAssetViews/{campaign_id}~{asset_id}~{asset_link_source}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String assetId;
    private final String assetLinkSource;
    private final String fieldType;

    @Deprecated
    protected CampaignAggregateAssetViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.assetId = null;
        this.assetLinkSource = null;
        this.fieldType = null;
    }

    private CampaignAggregateAssetViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.assetLinkSource = (String)Preconditions.checkNotNull((Object)builder.getAssetLinkSource());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getAssetLinkSource() {
        return this.assetLinkSource;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignAggregateAssetViewName of(String customerId, String campaignId, String assetId, String assetLinkSource, String fieldType) {
        return CampaignAggregateAssetViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setAssetLinkSource(assetLinkSource).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String campaignId, String assetId, String assetLinkSource, String fieldType) {
        return CampaignAggregateAssetViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setAssetLinkSource(assetLinkSource).setFieldType(fieldType).build().toString();
    }

    public static CampaignAggregateAssetViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_ASSET_LINK_SOURCE_FIELD_TYPE.validatedMatch(formattedString, "CampaignAggregateAssetViewName.parse: formattedString not in valid format");
        return CampaignAggregateAssetViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("asset_link_source"), (String)matchMap.get("field_type"));
    }

    public static List<CampaignAggregateAssetViewName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignAggregateAssetViewName> list = new ArrayList<CampaignAggregateAssetViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignAggregateAssetViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignAggregateAssetViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignAggregateAssetViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_ASSET_LINK_SOURCE_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignAggregateAssetViewName campaignAggregateAssetViewName = this;
            synchronized (campaignAggregateAssetViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.assetLinkSource != null) {
                        fieldMapBuilder.put((Object)"asset_link_source", (Object)this.assetLinkSource);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_ASSET_LINK_SOURCE_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "asset_id", this.assetId, "asset_link_source", this.assetLinkSource, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignAggregateAssetViewName that = (CampaignAggregateAssetViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.assetLinkSource, that.assetLinkSource) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetLinkSource);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String assetId;
        private String assetLinkSource;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getAssetLinkSource() {
            return this.assetLinkSource;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setAssetLinkSource(String assetLinkSource) {
            this.assetLinkSource = assetLinkSource;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(CampaignAggregateAssetViewName campaignAggregateAssetViewName) {
            this.customerId = campaignAggregateAssetViewName.customerId;
            this.campaignId = campaignAggregateAssetViewName.campaignId;
            this.assetId = campaignAggregateAssetViewName.assetId;
            this.assetLinkSource = campaignAggregateAssetViewName.assetLinkSource;
            this.fieldType = campaignAggregateAssetViewName.fieldType;
        }

        public CampaignAggregateAssetViewName build() {
            return new CampaignAggregateAssetViewName(this);
        }
    }
}

