/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAdName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_AD_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String adId;

    @Deprecated
    protected AdGroupAdName() {
        this.customerId = null;
        this.adGroupId = null;
        this.adId = null;
    }

    private AdGroupAdName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.adId = (String)Preconditions.checkNotNull((Object)builder.getAdId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAdId() {
        return this.adId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAdName of(String customerId, String adGroupId, String adId) {
        return AdGroupAdName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).build();
    }

    public static String format(String customerId, String adGroupId, String adId) {
        return AdGroupAdName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).build().toString();
    }

    public static AdGroupAdName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_AD_ID.validatedMatch(formattedString, "AdGroupAdName.parse: formattedString not in valid format");
        return AdGroupAdName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("ad_id"));
    }

    public static List<AdGroupAdName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdName> list = new ArrayList<AdGroupAdName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdName adGroupAdName = this;
            synchronized (adGroupAdName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.adId != null) {
                        fieldMapBuilder.put((Object)"ad_id", (Object)this.adId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "ad_id", this.adId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupAdName that = (AdGroupAdName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.adId, that.adId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String adId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAdId() {
            return this.adId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAdId(String adId) {
            this.adId = adId;
            return this;
        }

        private Builder(AdGroupAdName adGroupAdName) {
            this.customerId = adGroupAdName.customerId;
            this.adGroupId = adGroupAdName.adGroupId;
            this.adId = adGroupAdName.adId;
        }

        public AdGroupAdName build() {
            return new AdGroupAdName(this);
        }
    }
}

