/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetGroupSignalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_GROUP_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetGroupSignals/{asset_group_id}~{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetGroupId;
    private final String criterionId;

    @Deprecated
    protected AssetGroupSignalName() {
        this.customerId = null;
        this.assetGroupId = null;
        this.criterionId = null;
    }

    private AssetGroupSignalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetGroupId = (String)Preconditions.checkNotNull((Object)builder.getAssetGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetGroupSignalName of(String customerId, String assetGroupId, String criterionId) {
        return AssetGroupSignalName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String assetGroupId, String criterionId) {
        return AssetGroupSignalName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setCriterionId(criterionId).build().toString();
    }

    public static AssetGroupSignalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_GROUP_ID_CRITERION_ID.validatedMatch(formattedString, "AssetGroupSignalName.parse: formattedString not in valid format");
        return AssetGroupSignalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_group_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<AssetGroupSignalName> parseList(List<String> formattedStrings) {
        ArrayList<AssetGroupSignalName> list = new ArrayList<AssetGroupSignalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetGroupSignalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetGroupSignalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetGroupSignalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_GROUP_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetGroupSignalName assetGroupSignalName = this;
            synchronized (assetGroupSignalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetGroupId != null) {
                        fieldMapBuilder.put((Object)"asset_group_id", (Object)this.assetGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_GROUP_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_group_id", this.assetGroupId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetGroupSignalName that = (AssetGroupSignalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetGroupId, that.assetGroupId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String assetGroupId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetGroupId() {
            return this.assetGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetGroupId(String assetGroupId) {
            this.assetGroupId = assetGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(AssetGroupSignalName assetGroupSignalName) {
            this.customerId = assetGroupSignalName.customerId;
            this.assetGroupId = assetGroupSignalName.assetGroupId;
            this.criterionId = assetGroupSignalName.criterionId;
        }

        public AssetGroupSignalName build() {
            return new AssetGroupSignalName(this);
        }
    }
}

