/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignConversionGoalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_CATEGORY_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignConversionGoals/{campaign_id}~{category}~{source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String category;
    private final String source;

    @Deprecated
    protected CampaignConversionGoalName() {
        this.customerId = null;
        this.campaignId = null;
        this.category = null;
        this.source = null;
    }

    private CampaignConversionGoalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.category = (String)Preconditions.checkNotNull((Object)builder.getCategory());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignConversionGoalName of(String customerId, String campaignId, String category, String source) {
        return CampaignConversionGoalName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCategory(category).setSource(source).build();
    }

    public static String format(String customerId, String campaignId, String category, String source) {
        return CampaignConversionGoalName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCategory(category).setSource(source).build().toString();
    }

    public static CampaignConversionGoalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_CATEGORY_SOURCE.validatedMatch(formattedString, "CampaignConversionGoalName.parse: formattedString not in valid format");
        return CampaignConversionGoalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("category"), (String)matchMap.get("source"));
    }

    public static List<CampaignConversionGoalName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignConversionGoalName> list = new ArrayList<CampaignConversionGoalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignConversionGoalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignConversionGoalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignConversionGoalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_CATEGORY_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignConversionGoalName campaignConversionGoalName = this;
            synchronized (campaignConversionGoalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.category != null) {
                        fieldMapBuilder.put((Object)"category", (Object)this.category);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_CATEGORY_SOURCE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "category", this.category, "source", this.source});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignConversionGoalName that = (CampaignConversionGoalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.category, that.category) && Objects.equals(this.source, that.source);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.category);
        h *= 1000003;
        return h ^= Objects.hashCode(this.source);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String category;
        private String source;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        private Builder(CampaignConversionGoalName campaignConversionGoalName) {
            this.customerId = campaignConversionGoalName.customerId;
            this.campaignId = campaignConversionGoalName.campaignId;
            this.category = campaignConversionGoalName.category;
            this.source = campaignConversionGoalName.source;
        }

        public CampaignConversionGoalName build() {
            return new CampaignConversionGoalName(this);
        }
    }
}

