/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionValueRuleSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CONVERSION_VALUE_RULE_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/conversionValueRuleSets/{conversion_value_rule_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String conversionValueRuleSetId;

    @Deprecated
    protected ConversionValueRuleSetName() {
        this.customerId = null;
        this.conversionValueRuleSetId = null;
    }

    private ConversionValueRuleSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.conversionValueRuleSetId = (String)Preconditions.checkNotNull((Object)builder.getConversionValueRuleSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getConversionValueRuleSetId() {
        return this.conversionValueRuleSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionValueRuleSetName of(String customerId, String conversionValueRuleSetId) {
        return ConversionValueRuleSetName.newBuilder().setCustomerId(customerId).setConversionValueRuleSetId(conversionValueRuleSetId).build();
    }

    public static String format(String customerId, String conversionValueRuleSetId) {
        return ConversionValueRuleSetName.newBuilder().setCustomerId(customerId).setConversionValueRuleSetId(conversionValueRuleSetId).build().toString();
    }

    public static ConversionValueRuleSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CONVERSION_VALUE_RULE_SET_ID.validatedMatch(formattedString, "ConversionValueRuleSetName.parse: formattedString not in valid format");
        return ConversionValueRuleSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("conversion_value_rule_set_id"));
    }

    public static List<ConversionValueRuleSetName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionValueRuleSetName> list = new ArrayList<ConversionValueRuleSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionValueRuleSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionValueRuleSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionValueRuleSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CONVERSION_VALUE_RULE_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionValueRuleSetName conversionValueRuleSetName = this;
            synchronized (conversionValueRuleSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.conversionValueRuleSetId != null) {
                        fieldMapBuilder.put((Object)"conversion_value_rule_set_id", (Object)this.conversionValueRuleSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CONVERSION_VALUE_RULE_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "conversion_value_rule_set_id", this.conversionValueRuleSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversionValueRuleSetName that = (ConversionValueRuleSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.conversionValueRuleSetId, that.conversionValueRuleSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionValueRuleSetId);
    }

    public static class Builder {
        private String customerId;
        private String conversionValueRuleSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getConversionValueRuleSetId() {
            return this.conversionValueRuleSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setConversionValueRuleSetId(String conversionValueRuleSetId) {
            this.conversionValueRuleSetId = conversionValueRuleSetId;
            return this;
        }

        private Builder(ConversionValueRuleSetName conversionValueRuleSetName) {
            this.customerId = conversionValueRuleSetName.customerId;
            this.conversionValueRuleSetId = conversionValueRuleSetName.conversionValueRuleSetId;
        }

        public ConversionValueRuleSetName build() {
            return new ConversionValueRuleSetName(this);
        }
    }
}

