/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupContentSuitabilityPlacementViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PLACEMENT_FINGERPRINT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/groupContentSuitabilityPlacementViews/{placement_fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String placementFingerprint;

    @Deprecated
    protected GroupContentSuitabilityPlacementViewName() {
        this.customerId = null;
        this.placementFingerprint = null;
    }

    private GroupContentSuitabilityPlacementViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.placementFingerprint = (String)Preconditions.checkNotNull((Object)builder.getPlacementFingerprint());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPlacementFingerprint() {
        return this.placementFingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GroupContentSuitabilityPlacementViewName of(String customerId, String placementFingerprint) {
        return GroupContentSuitabilityPlacementViewName.newBuilder().setCustomerId(customerId).setPlacementFingerprint(placementFingerprint).build();
    }

    public static String format(String customerId, String placementFingerprint) {
        return GroupContentSuitabilityPlacementViewName.newBuilder().setCustomerId(customerId).setPlacementFingerprint(placementFingerprint).build().toString();
    }

    public static GroupContentSuitabilityPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PLACEMENT_FINGERPRINT.validatedMatch(formattedString, "GroupContentSuitabilityPlacementViewName.parse: formattedString not in valid format");
        return GroupContentSuitabilityPlacementViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("placement_fingerprint"));
    }

    public static List<GroupContentSuitabilityPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<GroupContentSuitabilityPlacementViewName> list = new ArrayList<GroupContentSuitabilityPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupContentSuitabilityPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupContentSuitabilityPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupContentSuitabilityPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PLACEMENT_FINGERPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupContentSuitabilityPlacementViewName groupContentSuitabilityPlacementViewName = this;
            synchronized (groupContentSuitabilityPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.placementFingerprint != null) {
                        fieldMapBuilder.put((Object)"placement_fingerprint", (Object)this.placementFingerprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PLACEMENT_FINGERPRINT.instantiate(new String[]{"customer_id", this.customerId, "placement_fingerprint", this.placementFingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GroupContentSuitabilityPlacementViewName that = (GroupContentSuitabilityPlacementViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.placementFingerprint, that.placementFingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.placementFingerprint);
    }

    public static class Builder {
        private String customerId;
        private String placementFingerprint;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getPlacementFingerprint() {
            return this.placementFingerprint;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setPlacementFingerprint(String placementFingerprint) {
            this.placementFingerprint = placementFingerprint;
            return this;
        }

        private Builder(GroupContentSuitabilityPlacementViewName groupContentSuitabilityPlacementViewName) {
            this.customerId = groupContentSuitabilityPlacementViewName.customerId;
            this.placementFingerprint = groupContentSuitabilityPlacementViewName.placementFingerprint;
        }

        public GroupContentSuitabilityPlacementViewName build() {
            return new GroupContentSuitabilityPlacementViewName(this);
        }
    }
}

