/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocalServicesLeadConversationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_LOCAL_SERVICES_LEAD_CONVERSATION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/localServicesLeadConversations/{local_services_lead_conversation_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String localServicesLeadConversationId;

    @Deprecated
    protected LocalServicesLeadConversationName() {
        this.customerId = null;
        this.localServicesLeadConversationId = null;
    }

    private LocalServicesLeadConversationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.localServicesLeadConversationId = (String)Preconditions.checkNotNull((Object)builder.getLocalServicesLeadConversationId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLocalServicesLeadConversationId() {
        return this.localServicesLeadConversationId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocalServicesLeadConversationName of(String customerId, String localServicesLeadConversationId) {
        return LocalServicesLeadConversationName.newBuilder().setCustomerId(customerId).setLocalServicesLeadConversationId(localServicesLeadConversationId).build();
    }

    public static String format(String customerId, String localServicesLeadConversationId) {
        return LocalServicesLeadConversationName.newBuilder().setCustomerId(customerId).setLocalServicesLeadConversationId(localServicesLeadConversationId).build().toString();
    }

    public static LocalServicesLeadConversationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_LOCAL_SERVICES_LEAD_CONVERSATION_ID.validatedMatch(formattedString, "LocalServicesLeadConversationName.parse: formattedString not in valid format");
        return LocalServicesLeadConversationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("local_services_lead_conversation_id"));
    }

    public static List<LocalServicesLeadConversationName> parseList(List<String> formattedStrings) {
        ArrayList<LocalServicesLeadConversationName> list = new ArrayList<LocalServicesLeadConversationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocalServicesLeadConversationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocalServicesLeadConversationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocalServicesLeadConversationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_LOCAL_SERVICES_LEAD_CONVERSATION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocalServicesLeadConversationName localServicesLeadConversationName = this;
            synchronized (localServicesLeadConversationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.localServicesLeadConversationId != null) {
                        fieldMapBuilder.put((Object)"local_services_lead_conversation_id", (Object)this.localServicesLeadConversationId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_LOCAL_SERVICES_LEAD_CONVERSATION_ID.instantiate(new String[]{"customer_id", this.customerId, "local_services_lead_conversation_id", this.localServicesLeadConversationId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocalServicesLeadConversationName that = (LocalServicesLeadConversationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.localServicesLeadConversationId, that.localServicesLeadConversationId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.localServicesLeadConversationId);
    }

    public static class Builder {
        private String customerId;
        private String localServicesLeadConversationId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getLocalServicesLeadConversationId() {
            return this.localServicesLeadConversationId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setLocalServicesLeadConversationId(String localServicesLeadConversationId) {
            this.localServicesLeadConversationId = localServicesLeadConversationId;
            return this;
        }

        private Builder(LocalServicesLeadConversationName localServicesLeadConversationName) {
            this.customerId = localServicesLeadConversationName.customerId;
            this.localServicesLeadConversationId = localServicesLeadConversationName.localServicesLeadConversationId;
        }

        public LocalServicesLeadConversationName build() {
            return new LocalServicesLeadConversationName(this);
        }
    }
}

