/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.ads.googleads.v22.enums.MediaTypeEnum;
import com.google.ads.googleads.v22.enums.MimeTypeEnum;
import com.google.ads.googleads.v22.resources.MediaAudio;
import com.google.ads.googleads.v22.resources.MediaAudioOrBuilder;
import com.google.ads.googleads.v22.resources.MediaBundle;
import com.google.ads.googleads.v22.resources.MediaBundleOrBuilder;
import com.google.ads.googleads.v22.resources.MediaFileOrBuilder;
import com.google.ads.googleads.v22.resources.MediaFileProto;
import com.google.ads.googleads.v22.resources.MediaImage;
import com.google.ads.googleads.v22.resources.MediaImageOrBuilder;
import com.google.ads.googleads.v22.resources.MediaVideo;
import com.google.ads.googleads.v22.resources.MediaVideoOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class MediaFile
extends GeneratedMessageV3
implements MediaFileOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int mediatypeCase_ = 0;
    private Object mediatype_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 12;
    private long id_ = 0L;
    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_ = 0;
    public static final int MIME_TYPE_FIELD_NUMBER = 6;
    private int mimeType_ = 0;
    public static final int SOURCE_URL_FIELD_NUMBER = 13;
    private volatile Object sourceUrl_ = "";
    public static final int NAME_FIELD_NUMBER = 14;
    private volatile Object name_ = "";
    public static final int FILE_SIZE_FIELD_NUMBER = 15;
    private long fileSize_ = 0L;
    public static final int IMAGE_FIELD_NUMBER = 3;
    public static final int MEDIA_BUNDLE_FIELD_NUMBER = 4;
    public static final int AUDIO_FIELD_NUMBER = 10;
    public static final int VIDEO_FIELD_NUMBER = 11;
    private byte memoizedIsInitialized = (byte)-1;
    private static final MediaFile DEFAULT_INSTANCE = new MediaFile();
    private static final Parser<MediaFile> PARSER = new AbstractParser<MediaFile>(){

        public MediaFile parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = MediaFile.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private MediaFile(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private MediaFile() {
        this.resourceName_ = "";
        this.type_ = 0;
        this.mimeType_ = 0;
        this.sourceUrl_ = "";
        this.name_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MediaFile();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MediaFileProto.internal_static_google_ads_googleads_v22_resources_MediaFile_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MediaFileProto.internal_static_google_ads_googleads_v22_resources_MediaFile_fieldAccessorTable.ensureFieldAccessorsInitialized(MediaFile.class, Builder.class);
    }

    @Override
    public MediatypeCase getMediatypeCase() {
        return MediatypeCase.forNumber(this.mediatypeCase_);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public MediaTypeEnum.MediaType getType() {
        MediaTypeEnum.MediaType result = MediaTypeEnum.MediaType.forNumber(this.type_);
        return result == null ? MediaTypeEnum.MediaType.UNRECOGNIZED : result;
    }

    @Override
    public int getMimeTypeValue() {
        return this.mimeType_;
    }

    @Override
    public MimeTypeEnum.MimeType getMimeType() {
        MimeTypeEnum.MimeType result = MimeTypeEnum.MimeType.forNumber(this.mimeType_);
        return result == null ? MimeTypeEnum.MimeType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasSourceUrl() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getSourceUrl() {
        Object ref = this.sourceUrl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sourceUrl_ = s;
        return s;
    }

    @Override
    public ByteString getSourceUrlBytes() {
        Object ref = this.sourceUrl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sourceUrl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasName() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasFileSize() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public long getFileSize() {
        return this.fileSize_;
    }

    @Override
    public boolean hasImage() {
        return this.mediatypeCase_ == 3;
    }

    @Override
    public MediaImage getImage() {
        if (this.mediatypeCase_ == 3) {
            return (MediaImage)this.mediatype_;
        }
        return MediaImage.getDefaultInstance();
    }

    @Override
    public MediaImageOrBuilder getImageOrBuilder() {
        if (this.mediatypeCase_ == 3) {
            return (MediaImage)this.mediatype_;
        }
        return MediaImage.getDefaultInstance();
    }

    @Override
    public boolean hasMediaBundle() {
        return this.mediatypeCase_ == 4;
    }

    @Override
    public MediaBundle getMediaBundle() {
        if (this.mediatypeCase_ == 4) {
            return (MediaBundle)this.mediatype_;
        }
        return MediaBundle.getDefaultInstance();
    }

    @Override
    public MediaBundleOrBuilder getMediaBundleOrBuilder() {
        if (this.mediatypeCase_ == 4) {
            return (MediaBundle)this.mediatype_;
        }
        return MediaBundle.getDefaultInstance();
    }

    @Override
    public boolean hasAudio() {
        return this.mediatypeCase_ == 10;
    }

    @Override
    public MediaAudio getAudio() {
        if (this.mediatypeCase_ == 10) {
            return (MediaAudio)this.mediatype_;
        }
        return MediaAudio.getDefaultInstance();
    }

    @Override
    public MediaAudioOrBuilder getAudioOrBuilder() {
        if (this.mediatypeCase_ == 10) {
            return (MediaAudio)this.mediatype_;
        }
        return MediaAudio.getDefaultInstance();
    }

    @Override
    public boolean hasVideo() {
        return this.mediatypeCase_ == 11;
    }

    @Override
    public MediaVideo getVideo() {
        if (this.mediatypeCase_ == 11) {
            return (MediaVideo)this.mediatype_;
        }
        return MediaVideo.getDefaultInstance();
    }

    @Override
    public MediaVideoOrBuilder getVideoOrBuilder() {
        if (this.mediatypeCase_ == 11) {
            return (MediaVideo)this.mediatype_;
        }
        return MediaVideo.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.mediatypeCase_ == 3) {
            output.writeMessage(3, (MessageLite)((MediaImage)this.mediatype_));
        }
        if (this.mediatypeCase_ == 4) {
            output.writeMessage(4, (MessageLite)((MediaBundle)this.mediatype_));
        }
        if (this.type_ != MediaTypeEnum.MediaType.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.type_);
        }
        if (this.mimeType_ != MimeTypeEnum.MimeType.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.mimeType_);
        }
        if (this.mediatypeCase_ == 10) {
            output.writeMessage(10, (MessageLite)((MediaAudio)this.mediatype_));
        }
        if (this.mediatypeCase_ == 11) {
            output.writeMessage(11, (MessageLite)((MediaVideo)this.mediatype_));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt64(12, this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.sourceUrl_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.name_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeInt64(15, this.fileSize_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.mediatypeCase_ == 3) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MediaImage)this.mediatype_));
        }
        if (this.mediatypeCase_ == 4) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MediaBundle)this.mediatype_));
        }
        if (this.type_ != MediaTypeEnum.MediaType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.type_);
        }
        if (this.mimeType_ != MimeTypeEnum.MimeType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.mimeType_);
        }
        if (this.mediatypeCase_ == 10) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MediaAudio)this.mediatype_));
        }
        if (this.mediatypeCase_ == 11) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MediaVideo)this.mediatype_));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt64Size((int)12, (long)this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.sourceUrl_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.name_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeInt64Size((int)15, (long)this.fileSize_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MediaFile)) {
            return super.equals(obj);
        }
        MediaFile other = (MediaFile)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasId() != other.hasId()) {
            return false;
        }
        if (this.hasId() && this.getId() != other.getId()) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.mimeType_ != other.mimeType_) {
            return false;
        }
        if (this.hasSourceUrl() != other.hasSourceUrl()) {
            return false;
        }
        if (this.hasSourceUrl() && !this.getSourceUrl().equals(other.getSourceUrl())) {
            return false;
        }
        if (this.hasName() != other.hasName()) {
            return false;
        }
        if (this.hasName() && !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasFileSize() != other.hasFileSize()) {
            return false;
        }
        if (this.hasFileSize() && this.getFileSize() != other.getFileSize()) {
            return false;
        }
        if (!this.getMediatypeCase().equals((Object)other.getMediatypeCase())) {
            return false;
        }
        switch (this.mediatypeCase_) {
            case 3: {
                if (this.getImage().equals(other.getImage())) break;
                return false;
            }
            case 4: {
                if (this.getMediaBundle().equals(other.getMediaBundle())) break;
                return false;
            }
            case 10: {
                if (this.getAudio().equals(other.getAudio())) break;
                return false;
            }
            case 11: {
                if (this.getVideo().equals(other.getVideo())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MediaFile.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasId()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + Internal.hashLong((long)this.getId());
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.mimeType_;
        if (this.hasSourceUrl()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getSourceUrl().hashCode();
        }
        if (this.hasName()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getName().hashCode();
        }
        if (this.hasFileSize()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + Internal.hashLong((long)this.getFileSize());
        }
        switch (this.mediatypeCase_) {
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getImage().hashCode();
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getMediaBundle().hashCode();
                break;
            }
            case 10: {
                hash = 37 * hash + 10;
                hash = 53 * hash + this.getAudio().hashCode();
                break;
            }
            case 11: {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getVideo().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static MediaFile parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data);
    }

    public static MediaFile parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MediaFile parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data);
    }

    public static MediaFile parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MediaFile parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data);
    }

    public static MediaFile parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MediaFile)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MediaFile parseFrom(InputStream input) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MediaFile parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MediaFile parseDelimitedFrom(InputStream input) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MediaFile parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MediaFile parseFrom(CodedInputStream input) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MediaFile parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MediaFile)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MediaFile.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MediaFile prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MediaFile getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MediaFile> parser() {
        return PARSER;
    }

    public Parser<MediaFile> getParserForType() {
        return PARSER;
    }

    public MediaFile getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements MediaFileOrBuilder {
        private int mediatypeCase_ = 0;
        private Object mediatype_;
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private int type_ = 0;
        private int mimeType_ = 0;
        private Object sourceUrl_ = "";
        private Object name_ = "";
        private long fileSize_;
        private SingleFieldBuilderV3<MediaImage, MediaImage.Builder, MediaImageOrBuilder> imageBuilder_;
        private SingleFieldBuilderV3<MediaBundle, MediaBundle.Builder, MediaBundleOrBuilder> mediaBundleBuilder_;
        private SingleFieldBuilderV3<MediaAudio, MediaAudio.Builder, MediaAudioOrBuilder> audioBuilder_;
        private SingleFieldBuilderV3<MediaVideo, MediaVideo.Builder, MediaVideoOrBuilder> videoBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return MediaFileProto.internal_static_google_ads_googleads_v22_resources_MediaFile_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MediaFileProto.internal_static_google_ads_googleads_v22_resources_MediaFile_fieldAccessorTable.ensureFieldAccessorsInitialized(MediaFile.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = 0L;
            this.type_ = 0;
            this.mimeType_ = 0;
            this.sourceUrl_ = "";
            this.name_ = "";
            this.fileSize_ = 0L;
            if (this.imageBuilder_ != null) {
                this.imageBuilder_.clear();
            }
            if (this.mediaBundleBuilder_ != null) {
                this.mediaBundleBuilder_.clear();
            }
            if (this.audioBuilder_ != null) {
                this.audioBuilder_.clear();
            }
            if (this.videoBuilder_ != null) {
                this.videoBuilder_.clear();
            }
            this.mediatypeCase_ = 0;
            this.mediatype_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MediaFileProto.internal_static_google_ads_googleads_v22_resources_MediaFile_descriptor;
        }

        public MediaFile getDefaultInstanceForType() {
            return MediaFile.getDefaultInstance();
        }

        public MediaFile build() {
            MediaFile result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MediaFile buildPartial() {
            MediaFile result = new MediaFile(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartial0(MediaFile result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.mimeType_ = this.mimeType_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.sourceUrl_ = this.sourceUrl_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.name_ = this.name_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.fileSize_ = this.fileSize_;
                to_bitField0_ |= 8;
            }
            result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(MediaFile result) {
            result.mediatypeCase_ = this.mediatypeCase_;
            result.mediatype_ = this.mediatype_;
            if (this.mediatypeCase_ == 3 && this.imageBuilder_ != null) {
                result.mediatype_ = this.imageBuilder_.build();
            }
            if (this.mediatypeCase_ == 4 && this.mediaBundleBuilder_ != null) {
                result.mediatype_ = this.mediaBundleBuilder_.build();
            }
            if (this.mediatypeCase_ == 10 && this.audioBuilder_ != null) {
                result.mediatype_ = this.audioBuilder_.build();
            }
            if (this.mediatypeCase_ == 11 && this.videoBuilder_ != null) {
                result.mediatype_ = this.videoBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MediaFile) {
                return this.mergeFrom((MediaFile)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MediaFile other) {
            if (other == MediaFile.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasId()) {
                this.setId(other.getId());
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.mimeType_ != 0) {
                this.setMimeTypeValue(other.getMimeTypeValue());
            }
            if (other.hasSourceUrl()) {
                this.sourceUrl_ = other.sourceUrl_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasName()) {
                this.name_ = other.name_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.hasFileSize()) {
                this.setFileSize(other.getFileSize());
            }
            switch (other.getMediatypeCase()) {
                case IMAGE: {
                    this.mergeImage(other.getImage());
                    break;
                }
                case MEDIA_BUNDLE: {
                    this.mergeMediaBundle(other.getMediaBundle());
                    break;
                }
                case AUDIO: {
                    this.mergeAudio(other.getAudio());
                    break;
                }
                case VIDEO: {
                    this.mergeVideo(other.getVideo());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getImageFieldBuilder().getBuilder(), extensionRegistry);
                            this.mediatypeCase_ = 3;
                            continue block19;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getMediaBundleFieldBuilder().getBuilder(), extensionRegistry);
                            this.mediatypeCase_ = 4;
                            continue block19;
                        }
                        case 40: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block19;
                        }
                        case 48: {
                            this.mimeType_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block19;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getAudioFieldBuilder().getBuilder(), extensionRegistry);
                            this.mediatypeCase_ = 10;
                            continue block19;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getVideoFieldBuilder().getBuilder(), extensionRegistry);
                            this.mediatypeCase_ = 11;
                            continue block19;
                        }
                        case 96: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 106: {
                            this.sourceUrl_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block19;
                        }
                        case 114: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 120: {
                            this.fileSize_ = input.readInt64();
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public MediatypeCase getMediatypeCase() {
            return MediatypeCase.forNumber(this.mediatypeCase_);
        }

        public Builder clearMediatype() {
            this.mediatypeCase_ = 0;
            this.mediatype_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = MediaFile.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MediaFile.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasId() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public MediaTypeEnum.MediaType getType() {
            MediaTypeEnum.MediaType result = MediaTypeEnum.MediaType.forNumber(this.type_);
            return result == null ? MediaTypeEnum.MediaType.UNRECOGNIZED : result;
        }

        public Builder setType(MediaTypeEnum.MediaType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getMimeTypeValue() {
            return this.mimeType_;
        }

        public Builder setMimeTypeValue(int value) {
            this.mimeType_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public MimeTypeEnum.MimeType getMimeType() {
            MimeTypeEnum.MimeType result = MimeTypeEnum.MimeType.forNumber(this.mimeType_);
            return result == null ? MimeTypeEnum.MimeType.UNRECOGNIZED : result;
        }

        public Builder setMimeType(MimeTypeEnum.MimeType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.mimeType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMimeType() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.mimeType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSourceUrl() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getSourceUrl() {
            Object ref = this.sourceUrl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sourceUrl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceUrlBytes() {
            Object ref = this.sourceUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sourceUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceUrl_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearSourceUrl() {
            this.sourceUrl_ = MediaFile.getDefaultInstance().getSourceUrl();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setSourceUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MediaFile.checkByteStringIsUtf8((ByteString)value);
            this.sourceUrl_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasName() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = MediaFile.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MediaFile.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFileSize() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public long getFileSize() {
            return this.fileSize_;
        }

        public Builder setFileSize(long value) {
            this.fileSize_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearFileSize() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.fileSize_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasImage() {
            return this.mediatypeCase_ == 3;
        }

        @Override
        public MediaImage getImage() {
            if (this.imageBuilder_ == null) {
                if (this.mediatypeCase_ == 3) {
                    return (MediaImage)this.mediatype_;
                }
                return MediaImage.getDefaultInstance();
            }
            if (this.mediatypeCase_ == 3) {
                return (MediaImage)this.imageBuilder_.getMessage();
            }
            return MediaImage.getDefaultInstance();
        }

        public Builder setImage(MediaImage value) {
            if (this.imageBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mediatype_ = value;
                this.onChanged();
            } else {
                this.imageBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 3;
            return this;
        }

        public Builder setImage(MediaImage.Builder builderForValue) {
            if (this.imageBuilder_ == null) {
                this.mediatype_ = builderForValue.build();
                this.onChanged();
            } else {
                this.imageBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.mediatypeCase_ = 3;
            return this;
        }

        public Builder mergeImage(MediaImage value) {
            if (this.imageBuilder_ == null) {
                this.mediatype_ = this.mediatypeCase_ == 3 && this.mediatype_ != MediaImage.getDefaultInstance() ? MediaImage.newBuilder((MediaImage)this.mediatype_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.mediatypeCase_ == 3) {
                this.imageBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.imageBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 3;
            return this;
        }

        public Builder clearImage() {
            if (this.imageBuilder_ == null) {
                if (this.mediatypeCase_ == 3) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                    this.onChanged();
                }
            } else {
                if (this.mediatypeCase_ == 3) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                }
                this.imageBuilder_.clear();
            }
            return this;
        }

        public MediaImage.Builder getImageBuilder() {
            return (MediaImage.Builder)this.getImageFieldBuilder().getBuilder();
        }

        @Override
        public MediaImageOrBuilder getImageOrBuilder() {
            if (this.mediatypeCase_ == 3 && this.imageBuilder_ != null) {
                return (MediaImageOrBuilder)this.imageBuilder_.getMessageOrBuilder();
            }
            if (this.mediatypeCase_ == 3) {
                return (MediaImage)this.mediatype_;
            }
            return MediaImage.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MediaImage, MediaImage.Builder, MediaImageOrBuilder> getImageFieldBuilder() {
            if (this.imageBuilder_ == null) {
                if (this.mediatypeCase_ != 3) {
                    this.mediatype_ = MediaImage.getDefaultInstance();
                }
                this.imageBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((MediaImage)this.mediatype_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mediatype_ = null;
            }
            this.mediatypeCase_ = 3;
            this.onChanged();
            return this.imageBuilder_;
        }

        @Override
        public boolean hasMediaBundle() {
            return this.mediatypeCase_ == 4;
        }

        @Override
        public MediaBundle getMediaBundle() {
            if (this.mediaBundleBuilder_ == null) {
                if (this.mediatypeCase_ == 4) {
                    return (MediaBundle)this.mediatype_;
                }
                return MediaBundle.getDefaultInstance();
            }
            if (this.mediatypeCase_ == 4) {
                return (MediaBundle)this.mediaBundleBuilder_.getMessage();
            }
            return MediaBundle.getDefaultInstance();
        }

        public Builder setMediaBundle(MediaBundle value) {
            if (this.mediaBundleBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mediatype_ = value;
                this.onChanged();
            } else {
                this.mediaBundleBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 4;
            return this;
        }

        public Builder setMediaBundle(MediaBundle.Builder builderForValue) {
            if (this.mediaBundleBuilder_ == null) {
                this.mediatype_ = builderForValue.build();
                this.onChanged();
            } else {
                this.mediaBundleBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.mediatypeCase_ = 4;
            return this;
        }

        public Builder mergeMediaBundle(MediaBundle value) {
            if (this.mediaBundleBuilder_ == null) {
                this.mediatype_ = this.mediatypeCase_ == 4 && this.mediatype_ != MediaBundle.getDefaultInstance() ? MediaBundle.newBuilder((MediaBundle)this.mediatype_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.mediatypeCase_ == 4) {
                this.mediaBundleBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.mediaBundleBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 4;
            return this;
        }

        public Builder clearMediaBundle() {
            if (this.mediaBundleBuilder_ == null) {
                if (this.mediatypeCase_ == 4) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                    this.onChanged();
                }
            } else {
                if (this.mediatypeCase_ == 4) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                }
                this.mediaBundleBuilder_.clear();
            }
            return this;
        }

        public MediaBundle.Builder getMediaBundleBuilder() {
            return (MediaBundle.Builder)this.getMediaBundleFieldBuilder().getBuilder();
        }

        @Override
        public MediaBundleOrBuilder getMediaBundleOrBuilder() {
            if (this.mediatypeCase_ == 4 && this.mediaBundleBuilder_ != null) {
                return (MediaBundleOrBuilder)this.mediaBundleBuilder_.getMessageOrBuilder();
            }
            if (this.mediatypeCase_ == 4) {
                return (MediaBundle)this.mediatype_;
            }
            return MediaBundle.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MediaBundle, MediaBundle.Builder, MediaBundleOrBuilder> getMediaBundleFieldBuilder() {
            if (this.mediaBundleBuilder_ == null) {
                if (this.mediatypeCase_ != 4) {
                    this.mediatype_ = MediaBundle.getDefaultInstance();
                }
                this.mediaBundleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((MediaBundle)this.mediatype_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mediatype_ = null;
            }
            this.mediatypeCase_ = 4;
            this.onChanged();
            return this.mediaBundleBuilder_;
        }

        @Override
        public boolean hasAudio() {
            return this.mediatypeCase_ == 10;
        }

        @Override
        public MediaAudio getAudio() {
            if (this.audioBuilder_ == null) {
                if (this.mediatypeCase_ == 10) {
                    return (MediaAudio)this.mediatype_;
                }
                return MediaAudio.getDefaultInstance();
            }
            if (this.mediatypeCase_ == 10) {
                return (MediaAudio)this.audioBuilder_.getMessage();
            }
            return MediaAudio.getDefaultInstance();
        }

        public Builder setAudio(MediaAudio value) {
            if (this.audioBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mediatype_ = value;
                this.onChanged();
            } else {
                this.audioBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 10;
            return this;
        }

        public Builder setAudio(MediaAudio.Builder builderForValue) {
            if (this.audioBuilder_ == null) {
                this.mediatype_ = builderForValue.build();
                this.onChanged();
            } else {
                this.audioBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.mediatypeCase_ = 10;
            return this;
        }

        public Builder mergeAudio(MediaAudio value) {
            if (this.audioBuilder_ == null) {
                this.mediatype_ = this.mediatypeCase_ == 10 && this.mediatype_ != MediaAudio.getDefaultInstance() ? MediaAudio.newBuilder((MediaAudio)this.mediatype_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.mediatypeCase_ == 10) {
                this.audioBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.audioBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 10;
            return this;
        }

        public Builder clearAudio() {
            if (this.audioBuilder_ == null) {
                if (this.mediatypeCase_ == 10) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                    this.onChanged();
                }
            } else {
                if (this.mediatypeCase_ == 10) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                }
                this.audioBuilder_.clear();
            }
            return this;
        }

        public MediaAudio.Builder getAudioBuilder() {
            return (MediaAudio.Builder)this.getAudioFieldBuilder().getBuilder();
        }

        @Override
        public MediaAudioOrBuilder getAudioOrBuilder() {
            if (this.mediatypeCase_ == 10 && this.audioBuilder_ != null) {
                return (MediaAudioOrBuilder)this.audioBuilder_.getMessageOrBuilder();
            }
            if (this.mediatypeCase_ == 10) {
                return (MediaAudio)this.mediatype_;
            }
            return MediaAudio.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MediaAudio, MediaAudio.Builder, MediaAudioOrBuilder> getAudioFieldBuilder() {
            if (this.audioBuilder_ == null) {
                if (this.mediatypeCase_ != 10) {
                    this.mediatype_ = MediaAudio.getDefaultInstance();
                }
                this.audioBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((MediaAudio)this.mediatype_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mediatype_ = null;
            }
            this.mediatypeCase_ = 10;
            this.onChanged();
            return this.audioBuilder_;
        }

        @Override
        public boolean hasVideo() {
            return this.mediatypeCase_ == 11;
        }

        @Override
        public MediaVideo getVideo() {
            if (this.videoBuilder_ == null) {
                if (this.mediatypeCase_ == 11) {
                    return (MediaVideo)this.mediatype_;
                }
                return MediaVideo.getDefaultInstance();
            }
            if (this.mediatypeCase_ == 11) {
                return (MediaVideo)this.videoBuilder_.getMessage();
            }
            return MediaVideo.getDefaultInstance();
        }

        public Builder setVideo(MediaVideo value) {
            if (this.videoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mediatype_ = value;
                this.onChanged();
            } else {
                this.videoBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 11;
            return this;
        }

        public Builder setVideo(MediaVideo.Builder builderForValue) {
            if (this.videoBuilder_ == null) {
                this.mediatype_ = builderForValue.build();
                this.onChanged();
            } else {
                this.videoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.mediatypeCase_ = 11;
            return this;
        }

        public Builder mergeVideo(MediaVideo value) {
            if (this.videoBuilder_ == null) {
                this.mediatype_ = this.mediatypeCase_ == 11 && this.mediatype_ != MediaVideo.getDefaultInstance() ? MediaVideo.newBuilder((MediaVideo)this.mediatype_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.mediatypeCase_ == 11) {
                this.videoBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.videoBuilder_.setMessage((AbstractMessage)value);
            }
            this.mediatypeCase_ = 11;
            return this;
        }

        public Builder clearVideo() {
            if (this.videoBuilder_ == null) {
                if (this.mediatypeCase_ == 11) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                    this.onChanged();
                }
            } else {
                if (this.mediatypeCase_ == 11) {
                    this.mediatypeCase_ = 0;
                    this.mediatype_ = null;
                }
                this.videoBuilder_.clear();
            }
            return this;
        }

        public MediaVideo.Builder getVideoBuilder() {
            return (MediaVideo.Builder)this.getVideoFieldBuilder().getBuilder();
        }

        @Override
        public MediaVideoOrBuilder getVideoOrBuilder() {
            if (this.mediatypeCase_ == 11 && this.videoBuilder_ != null) {
                return (MediaVideoOrBuilder)this.videoBuilder_.getMessageOrBuilder();
            }
            if (this.mediatypeCase_ == 11) {
                return (MediaVideo)this.mediatype_;
            }
            return MediaVideo.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MediaVideo, MediaVideo.Builder, MediaVideoOrBuilder> getVideoFieldBuilder() {
            if (this.videoBuilder_ == null) {
                if (this.mediatypeCase_ != 11) {
                    this.mediatype_ = MediaVideo.getDefaultInstance();
                }
                this.videoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((MediaVideo)this.mediatype_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mediatype_ = null;
            }
            this.mediatypeCase_ = 11;
            this.onChanged();
            return this.videoBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum MediatypeCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        IMAGE(3),
        MEDIA_BUNDLE(4),
        AUDIO(10),
        VIDEO(11),
        MEDIATYPE_NOT_SET(0);

        private final int value;

        private MediatypeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static MediatypeCase valueOf(int value) {
            return MediatypeCase.forNumber(value);
        }

        public static MediatypeCase forNumber(int value) {
            switch (value) {
                case 3: {
                    return IMAGE;
                }
                case 4: {
                    return MEDIA_BUNDLE;
                }
                case 10: {
                    return AUDIO;
                }
                case 11: {
                    return VIDEO;
                }
                case 0: {
                    return MEDIATYPE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

