/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductLinkInvitationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CUSTOMER_INVITATION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/productLinkInvitations/{customer_invitation_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String customerInvitationId;

    @Deprecated
    protected ProductLinkInvitationName() {
        this.customerId = null;
        this.customerInvitationId = null;
    }

    private ProductLinkInvitationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.customerInvitationId = (String)Preconditions.checkNotNull((Object)builder.getCustomerInvitationId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerInvitationId() {
        return this.customerInvitationId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductLinkInvitationName of(String customerId, String customerInvitationId) {
        return ProductLinkInvitationName.newBuilder().setCustomerId(customerId).setCustomerInvitationId(customerInvitationId).build();
    }

    public static String format(String customerId, String customerInvitationId) {
        return ProductLinkInvitationName.newBuilder().setCustomerId(customerId).setCustomerInvitationId(customerInvitationId).build().toString();
    }

    public static ProductLinkInvitationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CUSTOMER_INVITATION_ID.validatedMatch(formattedString, "ProductLinkInvitationName.parse: formattedString not in valid format");
        return ProductLinkInvitationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("customer_invitation_id"));
    }

    public static List<ProductLinkInvitationName> parseList(List<String> formattedStrings) {
        ArrayList<ProductLinkInvitationName> list = new ArrayList<ProductLinkInvitationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductLinkInvitationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductLinkInvitationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductLinkInvitationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CUSTOMER_INVITATION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductLinkInvitationName productLinkInvitationName = this;
            synchronized (productLinkInvitationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.customerInvitationId != null) {
                        fieldMapBuilder.put((Object)"customer_invitation_id", (Object)this.customerInvitationId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CUSTOMER_INVITATION_ID.instantiate(new String[]{"customer_id", this.customerId, "customer_invitation_id", this.customerInvitationId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProductLinkInvitationName that = (ProductLinkInvitationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.customerInvitationId, that.customerInvitationId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerInvitationId);
    }

    public static class Builder {
        private String customerId;
        private String customerInvitationId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCustomerInvitationId() {
            return this.customerInvitationId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCustomerInvitationId(String customerInvitationId) {
            this.customerInvitationId = customerInvitationId;
            return this;
        }

        private Builder(ProductLinkInvitationName productLinkInvitationName) {
            this.customerId = productLinkInvitationName.customerId;
            this.customerInvitationId = productLinkInvitationName.customerInvitationId;
        }

        public ProductLinkInvitationName build() {
            return new ProductLinkInvitationName(this);
        }
    }
}

