/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.services.AssetOperation;
import com.google.ads.googleads.v22.services.AssetServiceSettings;
import com.google.ads.googleads.v22.services.MutateAssetsRequest;
import com.google.ads.googleads.v22.services.MutateAssetsResponse;
import com.google.ads.googleads.v22.services.stub.AssetServiceStub;
import com.google.ads.googleads.v22.services.stub.AssetServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final MutateAssetsResponse mutateAssets(String customerId, List<AssetOperation> operations) {
        MutateAssetsRequest request = MutateAssetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAssets(request);
    }

    public final MutateAssetsResponse mutateAssets(MutateAssetsRequest request) {
        return (MutateAssetsResponse)this.mutateAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable() {
        return this.stub.mutateAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

