/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v22.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v22.services.AssetGenerationServiceProto;
import com.google.ads.googleads.v22.services.FinalUrlImageGenerationInput;
import com.google.ads.googleads.v22.services.FinalUrlImageGenerationInputOrBuilder;
import com.google.ads.googleads.v22.services.FreeformImageGenerationInput;
import com.google.ads.googleads.v22.services.FreeformImageGenerationInputOrBuilder;
import com.google.ads.googleads.v22.services.GenerateImagesRequestOrBuilder;
import com.google.ads.googleads.v22.services.ProductRecontextGenerationImageInput;
import com.google.ads.googleads.v22.services.ProductRecontextGenerationImageInputOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GenerateImagesRequest
extends GeneratedMessageV3
implements GenerateImagesRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int contextCase_ = 0;
    private Object context_;
    private int generationTypeCase_ = 0;
    private Object generationType_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int ASSET_FIELD_TYPES_FIELD_NUMBER = 4;
    private List<Integer> assetFieldTypes_;
    private static final Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType> assetFieldTypes_converter_ = new Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType>(){

        public AssetFieldTypeEnum.AssetFieldType convert(Integer from) {
            AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(from);
            return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
        }
    };
    private int assetFieldTypesMemoizedSerializedSize;
    public static final int ADVERTISING_CHANNEL_TYPE_FIELD_NUMBER = 2;
    public static final int FINAL_URL_GENERATION_FIELD_NUMBER = 5;
    public static final int FREEFORM_GENERATION_FIELD_NUMBER = 6;
    public static final int PRODUCT_RECONTEXT_GENERATION_FIELD_NUMBER = 7;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateImagesRequest DEFAULT_INSTANCE = new GenerateImagesRequest();
    private static final Parser<GenerateImagesRequest> PARSER = new AbstractParser<GenerateImagesRequest>(){

        public GenerateImagesRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateImagesRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateImagesRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateImagesRequest() {
        this.customerId_ = "";
        this.assetFieldTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateImagesRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateImagesRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateImagesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateImagesRequest.class, Builder.class);
    }

    @Override
    public ContextCase getContextCase() {
        return ContextCase.forNumber(this.contextCase_);
    }

    @Override
    public GenerationTypeCase getGenerationTypeCase() {
        return GenerationTypeCase.forNumber(this.generationTypeCase_);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AssetFieldTypeEnum.AssetFieldType> getAssetFieldTypesList() {
        return new Internal.ListAdapter(this.assetFieldTypes_, assetFieldTypes_converter_);
    }

    @Override
    public int getAssetFieldTypesCount() {
        return this.assetFieldTypes_.size();
    }

    @Override
    public AssetFieldTypeEnum.AssetFieldType getAssetFieldTypes(int index) {
        return (AssetFieldTypeEnum.AssetFieldType)((Object)assetFieldTypes_converter_.convert((Object)this.assetFieldTypes_.get(index)));
    }

    @Override
    public List<Integer> getAssetFieldTypesValueList() {
        return this.assetFieldTypes_;
    }

    @Override
    public int getAssetFieldTypesValue(int index) {
        return this.assetFieldTypes_.get(index);
    }

    @Override
    public boolean hasAdvertisingChannelType() {
        return this.contextCase_ == 2;
    }

    @Override
    public int getAdvertisingChannelTypeValue() {
        if (this.contextCase_ == 2) {
            return (Integer)this.context_;
        }
        return 0;
    }

    @Override
    public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
        if (this.contextCase_ == 2) {
            AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber((Integer)this.context_);
            return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
        }
        return AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED;
    }

    @Override
    public boolean hasFinalUrlGeneration() {
        return this.generationTypeCase_ == 5;
    }

    @Override
    public FinalUrlImageGenerationInput getFinalUrlGeneration() {
        if (this.generationTypeCase_ == 5) {
            return (FinalUrlImageGenerationInput)this.generationType_;
        }
        return FinalUrlImageGenerationInput.getDefaultInstance();
    }

    @Override
    public FinalUrlImageGenerationInputOrBuilder getFinalUrlGenerationOrBuilder() {
        if (this.generationTypeCase_ == 5) {
            return (FinalUrlImageGenerationInput)this.generationType_;
        }
        return FinalUrlImageGenerationInput.getDefaultInstance();
    }

    @Override
    public boolean hasFreeformGeneration() {
        return this.generationTypeCase_ == 6;
    }

    @Override
    public FreeformImageGenerationInput getFreeformGeneration() {
        if (this.generationTypeCase_ == 6) {
            return (FreeformImageGenerationInput)this.generationType_;
        }
        return FreeformImageGenerationInput.getDefaultInstance();
    }

    @Override
    public FreeformImageGenerationInputOrBuilder getFreeformGenerationOrBuilder() {
        if (this.generationTypeCase_ == 6) {
            return (FreeformImageGenerationInput)this.generationType_;
        }
        return FreeformImageGenerationInput.getDefaultInstance();
    }

    @Override
    public boolean hasProductRecontextGeneration() {
        return this.generationTypeCase_ == 7;
    }

    @Override
    public ProductRecontextGenerationImageInput getProductRecontextGeneration() {
        if (this.generationTypeCase_ == 7) {
            return (ProductRecontextGenerationImageInput)this.generationType_;
        }
        return ProductRecontextGenerationImageInput.getDefaultInstance();
    }

    @Override
    public ProductRecontextGenerationImageInputOrBuilder getProductRecontextGenerationOrBuilder() {
        if (this.generationTypeCase_ == 7) {
            return (ProductRecontextGenerationImageInput)this.generationType_;
        }
        return ProductRecontextGenerationImageInput.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if (this.contextCase_ == 2) {
            output.writeEnum(2, ((Integer)this.context_).intValue());
        }
        if (this.getAssetFieldTypesList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.assetFieldTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.assetFieldTypes_.size(); ++i) {
            output.writeEnumNoTag(this.assetFieldTypes_.get(i).intValue());
        }
        if (this.generationTypeCase_ == 5) {
            output.writeMessage(5, (MessageLite)((FinalUrlImageGenerationInput)this.generationType_));
        }
        if (this.generationTypeCase_ == 6) {
            output.writeMessage(6, (MessageLite)((FreeformImageGenerationInput)this.generationType_));
        }
        if (this.generationTypeCase_ == 7) {
            output.writeMessage(7, (MessageLite)((ProductRecontextGenerationImageInput)this.generationType_));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        if (this.contextCase_ == 2) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)((Integer)this.context_));
        }
        int dataSize = 0;
        for (int i = 0; i < this.assetFieldTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.assetFieldTypes_.get(i));
        }
        size += dataSize;
        if (!this.getAssetFieldTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.assetFieldTypesMemoizedSerializedSize = dataSize;
        if (this.generationTypeCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((FinalUrlImageGenerationInput)this.generationType_));
        }
        if (this.generationTypeCase_ == 6) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((FreeformImageGenerationInput)this.generationType_));
        }
        if (this.generationTypeCase_ == 7) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((ProductRecontextGenerationImageInput)this.generationType_));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateImagesRequest)) {
            return super.equals(obj);
        }
        GenerateImagesRequest other = (GenerateImagesRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.assetFieldTypes_.equals(other.assetFieldTypes_)) {
            return false;
        }
        if (!this.getContextCase().equals((Object)other.getContextCase())) {
            return false;
        }
        switch (this.contextCase_) {
            case 2: {
                if (this.getAdvertisingChannelTypeValue() == other.getAdvertisingChannelTypeValue()) break;
                return false;
            }
        }
        if (!this.getGenerationTypeCase().equals((Object)other.getGenerationTypeCase())) {
            return false;
        }
        switch (this.generationTypeCase_) {
            case 5: {
                if (this.getFinalUrlGeneration().equals(other.getFinalUrlGeneration())) break;
                return false;
            }
            case 6: {
                if (this.getFreeformGeneration().equals(other.getFreeformGeneration())) break;
                return false;
            }
            case 7: {
                if (this.getProductRecontextGeneration().equals(other.getProductRecontextGeneration())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateImagesRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getAssetFieldTypesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.assetFieldTypes_.hashCode();
        }
        switch (this.contextCase_) {
            case 2: {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getAdvertisingChannelTypeValue();
                break;
            }
        }
        switch (this.generationTypeCase_) {
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getFinalUrlGeneration().hashCode();
                break;
            }
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getFreeformGeneration().hashCode();
                break;
            }
            case 7: {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getProductRecontextGeneration().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateImagesRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data);
    }

    public static GenerateImagesRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateImagesRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data);
    }

    public static GenerateImagesRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateImagesRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data);
    }

    public static GenerateImagesRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateImagesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateImagesRequest parseFrom(InputStream input) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateImagesRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateImagesRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateImagesRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateImagesRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateImagesRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateImagesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateImagesRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateImagesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateImagesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateImagesRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateImagesRequest> getParserForType() {
        return PARSER;
    }

    public GenerateImagesRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateImagesRequestOrBuilder {
        private int contextCase_ = 0;
        private Object context_;
        private int generationTypeCase_ = 0;
        private Object generationType_;
        private int bitField0_;
        private Object customerId_ = "";
        private List<Integer> assetFieldTypes_ = Collections.emptyList();
        private SingleFieldBuilderV3<FinalUrlImageGenerationInput, FinalUrlImageGenerationInput.Builder, FinalUrlImageGenerationInputOrBuilder> finalUrlGenerationBuilder_;
        private SingleFieldBuilderV3<FreeformImageGenerationInput, FreeformImageGenerationInput.Builder, FreeformImageGenerationInputOrBuilder> freeformGenerationBuilder_;
        private SingleFieldBuilderV3<ProductRecontextGenerationImageInput, ProductRecontextGenerationImageInput.Builder, ProductRecontextGenerationImageInputOrBuilder> productRecontextGenerationBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateImagesRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateImagesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateImagesRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.assetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.finalUrlGenerationBuilder_ != null) {
                this.finalUrlGenerationBuilder_.clear();
            }
            if (this.freeformGenerationBuilder_ != null) {
                this.freeformGenerationBuilder_.clear();
            }
            if (this.productRecontextGenerationBuilder_ != null) {
                this.productRecontextGenerationBuilder_.clear();
            }
            this.contextCase_ = 0;
            this.context_ = null;
            this.generationTypeCase_ = 0;
            this.generationType_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetGenerationServiceProto.internal_static_google_ads_googleads_v22_services_GenerateImagesRequest_descriptor;
        }

        public GenerateImagesRequest getDefaultInstanceForType() {
            return GenerateImagesRequest.getDefaultInstance();
        }

        public GenerateImagesRequest build() {
            GenerateImagesRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateImagesRequest buildPartial() {
            GenerateImagesRequest result = new GenerateImagesRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateImagesRequest result) {
            if ((this.bitField0_ & 2) != 0) {
                this.assetFieldTypes_ = Collections.unmodifiableList(this.assetFieldTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.assetFieldTypes_ = this.assetFieldTypes_;
        }

        private void buildPartial0(GenerateImagesRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
        }

        private void buildPartialOneofs(GenerateImagesRequest result) {
            result.contextCase_ = this.contextCase_;
            result.context_ = this.context_;
            result.generationTypeCase_ = this.generationTypeCase_;
            result.generationType_ = this.generationType_;
            if (this.generationTypeCase_ == 5 && this.finalUrlGenerationBuilder_ != null) {
                result.generationType_ = this.finalUrlGenerationBuilder_.build();
            }
            if (this.generationTypeCase_ == 6 && this.freeformGenerationBuilder_ != null) {
                result.generationType_ = this.freeformGenerationBuilder_.build();
            }
            if (this.generationTypeCase_ == 7 && this.productRecontextGenerationBuilder_ != null) {
                result.generationType_ = this.productRecontextGenerationBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateImagesRequest) {
                return this.mergeFrom((GenerateImagesRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateImagesRequest other) {
            if (other == GenerateImagesRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.assetFieldTypes_.isEmpty()) {
                if (this.assetFieldTypes_.isEmpty()) {
                    this.assetFieldTypes_ = other.assetFieldTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureAssetFieldTypesIsMutable();
                    this.assetFieldTypes_.addAll(other.assetFieldTypes_);
                }
                this.onChanged();
            }
            switch (other.getContextCase()) {
                case ADVERTISING_CHANNEL_TYPE: {
                    this.setAdvertisingChannelTypeValue(other.getAdvertisingChannelTypeValue());
                    break;
                }
            }
            switch (other.getGenerationTypeCase()) {
                case FINAL_URL_GENERATION: {
                    this.mergeFinalUrlGeneration(other.getFinalUrlGeneration());
                    break;
                }
                case FREEFORM_GENERATION: {
                    this.mergeFreeformGeneration(other.getFreeformGeneration());
                    break;
                }
                case PRODUCT_RECONTEXT_GENERATION: {
                    this.mergeProductRecontextGeneration(other.getProductRecontextGeneration());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 16: {
                            int rawValue = input.readEnum();
                            this.contextCase_ = 2;
                            this.context_ = rawValue;
                            continue block15;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensureAssetFieldTypesIsMutable();
                            this.assetFieldTypes_.add(tmpRaw);
                            continue block15;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureAssetFieldTypesIsMutable();
                                this.assetFieldTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block15;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getFinalUrlGenerationFieldBuilder().getBuilder(), extensionRegistry);
                            this.generationTypeCase_ = 5;
                            continue block15;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getFreeformGenerationFieldBuilder().getBuilder(), extensionRegistry);
                            this.generationTypeCase_ = 6;
                            continue block15;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getProductRecontextGenerationFieldBuilder().getBuilder(), extensionRegistry);
                            this.generationTypeCase_ = 7;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public ContextCase getContextCase() {
            return ContextCase.forNumber(this.contextCase_);
        }

        public Builder clearContext() {
            this.contextCase_ = 0;
            this.context_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public GenerationTypeCase getGenerationTypeCase() {
            return GenerationTypeCase.forNumber(this.generationTypeCase_);
        }

        public Builder clearGenerationType() {
            this.generationTypeCase_ = 0;
            this.generationType_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateImagesRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateImagesRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureAssetFieldTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.assetFieldTypes_ = new ArrayList<Integer>(this.assetFieldTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AssetFieldTypeEnum.AssetFieldType> getAssetFieldTypesList() {
            return new Internal.ListAdapter(this.assetFieldTypes_, assetFieldTypes_converter_);
        }

        @Override
        public int getAssetFieldTypesCount() {
            return this.assetFieldTypes_.size();
        }

        @Override
        public AssetFieldTypeEnum.AssetFieldType getAssetFieldTypes(int index) {
            return (AssetFieldTypeEnum.AssetFieldType)((Object)assetFieldTypes_converter_.convert((Object)this.assetFieldTypes_.get(index)));
        }

        public Builder setAssetFieldTypes(int index, AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAssetFieldTypes(AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAssetFieldTypes(Iterable<? extends AssetFieldTypeEnum.AssetFieldType> values) {
            this.ensureAssetFieldTypesIsMutable();
            for (AssetFieldTypeEnum.AssetFieldType assetFieldType : values) {
                this.assetFieldTypes_.add(assetFieldType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAssetFieldTypes() {
            this.assetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAssetFieldTypesValueList() {
            return Collections.unmodifiableList(this.assetFieldTypes_);
        }

        @Override
        public int getAssetFieldTypesValue(int index) {
            return this.assetFieldTypes_.get(index);
        }

        public Builder setAssetFieldTypesValue(int index, int value) {
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAssetFieldTypesValue(int value) {
            this.ensureAssetFieldTypesIsMutable();
            this.assetFieldTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAssetFieldTypesValue(Iterable<Integer> values) {
            this.ensureAssetFieldTypesIsMutable();
            for (int value : values) {
                this.assetFieldTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAdvertisingChannelType() {
            return this.contextCase_ == 2;
        }

        @Override
        public int getAdvertisingChannelTypeValue() {
            if (this.contextCase_ == 2) {
                return (Integer)this.context_;
            }
            return 0;
        }

        public Builder setAdvertisingChannelTypeValue(int value) {
            this.contextCase_ = 2;
            this.context_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public AdvertisingChannelTypeEnum.AdvertisingChannelType getAdvertisingChannelType() {
            if (this.contextCase_ == 2) {
                AdvertisingChannelTypeEnum.AdvertisingChannelType result = AdvertisingChannelTypeEnum.AdvertisingChannelType.forNumber((Integer)this.context_);
                return result == null ? AdvertisingChannelTypeEnum.AdvertisingChannelType.UNRECOGNIZED : result;
            }
            return AdvertisingChannelTypeEnum.AdvertisingChannelType.UNSPECIFIED;
        }

        public Builder setAdvertisingChannelType(AdvertisingChannelTypeEnum.AdvertisingChannelType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.contextCase_ = 2;
            this.context_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisingChannelType() {
            if (this.contextCase_ == 2) {
                this.contextCase_ = 0;
                this.context_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasFinalUrlGeneration() {
            return this.generationTypeCase_ == 5;
        }

        @Override
        public FinalUrlImageGenerationInput getFinalUrlGeneration() {
            if (this.finalUrlGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 5) {
                    return (FinalUrlImageGenerationInput)this.generationType_;
                }
                return FinalUrlImageGenerationInput.getDefaultInstance();
            }
            if (this.generationTypeCase_ == 5) {
                return (FinalUrlImageGenerationInput)this.finalUrlGenerationBuilder_.getMessage();
            }
            return FinalUrlImageGenerationInput.getDefaultInstance();
        }

        public Builder setFinalUrlGeneration(FinalUrlImageGenerationInput value) {
            if (this.finalUrlGenerationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.generationType_ = value;
                this.onChanged();
            } else {
                this.finalUrlGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 5;
            return this;
        }

        public Builder setFinalUrlGeneration(FinalUrlImageGenerationInput.Builder builderForValue) {
            if (this.finalUrlGenerationBuilder_ == null) {
                this.generationType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.finalUrlGenerationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.generationTypeCase_ = 5;
            return this;
        }

        public Builder mergeFinalUrlGeneration(FinalUrlImageGenerationInput value) {
            if (this.finalUrlGenerationBuilder_ == null) {
                this.generationType_ = this.generationTypeCase_ == 5 && this.generationType_ != FinalUrlImageGenerationInput.getDefaultInstance() ? FinalUrlImageGenerationInput.newBuilder((FinalUrlImageGenerationInput)this.generationType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.generationTypeCase_ == 5) {
                this.finalUrlGenerationBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.finalUrlGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 5;
            return this;
        }

        public Builder clearFinalUrlGeneration() {
            if (this.finalUrlGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 5) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.generationTypeCase_ == 5) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                }
                this.finalUrlGenerationBuilder_.clear();
            }
            return this;
        }

        public FinalUrlImageGenerationInput.Builder getFinalUrlGenerationBuilder() {
            return (FinalUrlImageGenerationInput.Builder)this.getFinalUrlGenerationFieldBuilder().getBuilder();
        }

        @Override
        public FinalUrlImageGenerationInputOrBuilder getFinalUrlGenerationOrBuilder() {
            if (this.generationTypeCase_ == 5 && this.finalUrlGenerationBuilder_ != null) {
                return (FinalUrlImageGenerationInputOrBuilder)this.finalUrlGenerationBuilder_.getMessageOrBuilder();
            }
            if (this.generationTypeCase_ == 5) {
                return (FinalUrlImageGenerationInput)this.generationType_;
            }
            return FinalUrlImageGenerationInput.getDefaultInstance();
        }

        private SingleFieldBuilderV3<FinalUrlImageGenerationInput, FinalUrlImageGenerationInput.Builder, FinalUrlImageGenerationInputOrBuilder> getFinalUrlGenerationFieldBuilder() {
            if (this.finalUrlGenerationBuilder_ == null) {
                if (this.generationTypeCase_ != 5) {
                    this.generationType_ = FinalUrlImageGenerationInput.getDefaultInstance();
                }
                this.finalUrlGenerationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((FinalUrlImageGenerationInput)this.generationType_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.generationType_ = null;
            }
            this.generationTypeCase_ = 5;
            this.onChanged();
            return this.finalUrlGenerationBuilder_;
        }

        @Override
        public boolean hasFreeformGeneration() {
            return this.generationTypeCase_ == 6;
        }

        @Override
        public FreeformImageGenerationInput getFreeformGeneration() {
            if (this.freeformGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 6) {
                    return (FreeformImageGenerationInput)this.generationType_;
                }
                return FreeformImageGenerationInput.getDefaultInstance();
            }
            if (this.generationTypeCase_ == 6) {
                return (FreeformImageGenerationInput)this.freeformGenerationBuilder_.getMessage();
            }
            return FreeformImageGenerationInput.getDefaultInstance();
        }

        public Builder setFreeformGeneration(FreeformImageGenerationInput value) {
            if (this.freeformGenerationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.generationType_ = value;
                this.onChanged();
            } else {
                this.freeformGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 6;
            return this;
        }

        public Builder setFreeformGeneration(FreeformImageGenerationInput.Builder builderForValue) {
            if (this.freeformGenerationBuilder_ == null) {
                this.generationType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.freeformGenerationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.generationTypeCase_ = 6;
            return this;
        }

        public Builder mergeFreeformGeneration(FreeformImageGenerationInput value) {
            if (this.freeformGenerationBuilder_ == null) {
                this.generationType_ = this.generationTypeCase_ == 6 && this.generationType_ != FreeformImageGenerationInput.getDefaultInstance() ? FreeformImageGenerationInput.newBuilder((FreeformImageGenerationInput)this.generationType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.generationTypeCase_ == 6) {
                this.freeformGenerationBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.freeformGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 6;
            return this;
        }

        public Builder clearFreeformGeneration() {
            if (this.freeformGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 6) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.generationTypeCase_ == 6) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                }
                this.freeformGenerationBuilder_.clear();
            }
            return this;
        }

        public FreeformImageGenerationInput.Builder getFreeformGenerationBuilder() {
            return (FreeformImageGenerationInput.Builder)this.getFreeformGenerationFieldBuilder().getBuilder();
        }

        @Override
        public FreeformImageGenerationInputOrBuilder getFreeformGenerationOrBuilder() {
            if (this.generationTypeCase_ == 6 && this.freeformGenerationBuilder_ != null) {
                return (FreeformImageGenerationInputOrBuilder)this.freeformGenerationBuilder_.getMessageOrBuilder();
            }
            if (this.generationTypeCase_ == 6) {
                return (FreeformImageGenerationInput)this.generationType_;
            }
            return FreeformImageGenerationInput.getDefaultInstance();
        }

        private SingleFieldBuilderV3<FreeformImageGenerationInput, FreeformImageGenerationInput.Builder, FreeformImageGenerationInputOrBuilder> getFreeformGenerationFieldBuilder() {
            if (this.freeformGenerationBuilder_ == null) {
                if (this.generationTypeCase_ != 6) {
                    this.generationType_ = FreeformImageGenerationInput.getDefaultInstance();
                }
                this.freeformGenerationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((FreeformImageGenerationInput)this.generationType_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.generationType_ = null;
            }
            this.generationTypeCase_ = 6;
            this.onChanged();
            return this.freeformGenerationBuilder_;
        }

        @Override
        public boolean hasProductRecontextGeneration() {
            return this.generationTypeCase_ == 7;
        }

        @Override
        public ProductRecontextGenerationImageInput getProductRecontextGeneration() {
            if (this.productRecontextGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 7) {
                    return (ProductRecontextGenerationImageInput)this.generationType_;
                }
                return ProductRecontextGenerationImageInput.getDefaultInstance();
            }
            if (this.generationTypeCase_ == 7) {
                return (ProductRecontextGenerationImageInput)this.productRecontextGenerationBuilder_.getMessage();
            }
            return ProductRecontextGenerationImageInput.getDefaultInstance();
        }

        public Builder setProductRecontextGeneration(ProductRecontextGenerationImageInput value) {
            if (this.productRecontextGenerationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.generationType_ = value;
                this.onChanged();
            } else {
                this.productRecontextGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 7;
            return this;
        }

        public Builder setProductRecontextGeneration(ProductRecontextGenerationImageInput.Builder builderForValue) {
            if (this.productRecontextGenerationBuilder_ == null) {
                this.generationType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.productRecontextGenerationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.generationTypeCase_ = 7;
            return this;
        }

        public Builder mergeProductRecontextGeneration(ProductRecontextGenerationImageInput value) {
            if (this.productRecontextGenerationBuilder_ == null) {
                this.generationType_ = this.generationTypeCase_ == 7 && this.generationType_ != ProductRecontextGenerationImageInput.getDefaultInstance() ? ProductRecontextGenerationImageInput.newBuilder((ProductRecontextGenerationImageInput)this.generationType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.generationTypeCase_ == 7) {
                this.productRecontextGenerationBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.productRecontextGenerationBuilder_.setMessage((AbstractMessage)value);
            }
            this.generationTypeCase_ = 7;
            return this;
        }

        public Builder clearProductRecontextGeneration() {
            if (this.productRecontextGenerationBuilder_ == null) {
                if (this.generationTypeCase_ == 7) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.generationTypeCase_ == 7) {
                    this.generationTypeCase_ = 0;
                    this.generationType_ = null;
                }
                this.productRecontextGenerationBuilder_.clear();
            }
            return this;
        }

        public ProductRecontextGenerationImageInput.Builder getProductRecontextGenerationBuilder() {
            return (ProductRecontextGenerationImageInput.Builder)this.getProductRecontextGenerationFieldBuilder().getBuilder();
        }

        @Override
        public ProductRecontextGenerationImageInputOrBuilder getProductRecontextGenerationOrBuilder() {
            if (this.generationTypeCase_ == 7 && this.productRecontextGenerationBuilder_ != null) {
                return (ProductRecontextGenerationImageInputOrBuilder)this.productRecontextGenerationBuilder_.getMessageOrBuilder();
            }
            if (this.generationTypeCase_ == 7) {
                return (ProductRecontextGenerationImageInput)this.generationType_;
            }
            return ProductRecontextGenerationImageInput.getDefaultInstance();
        }

        private SingleFieldBuilderV3<ProductRecontextGenerationImageInput, ProductRecontextGenerationImageInput.Builder, ProductRecontextGenerationImageInputOrBuilder> getProductRecontextGenerationFieldBuilder() {
            if (this.productRecontextGenerationBuilder_ == null) {
                if (this.generationTypeCase_ != 7) {
                    this.generationType_ = ProductRecontextGenerationImageInput.getDefaultInstance();
                }
                this.productRecontextGenerationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((ProductRecontextGenerationImageInput)this.generationType_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.generationType_ = null;
            }
            this.generationTypeCase_ = 7;
            this.onChanged();
            return this.productRecontextGenerationBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ContextCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        ADVERTISING_CHANNEL_TYPE(2),
        CONTEXT_NOT_SET(0);

        private final int value;

        private ContextCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static ContextCase valueOf(int value) {
            return ContextCase.forNumber(value);
        }

        public static ContextCase forNumber(int value) {
            switch (value) {
                case 2: {
                    return ADVERTISING_CHANNEL_TYPE;
                }
                case 0: {
                    return CONTEXT_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static enum GenerationTypeCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        FINAL_URL_GENERATION(5),
        FREEFORM_GENERATION(6),
        PRODUCT_RECONTEXT_GENERATION(7),
        GENERATIONTYPE_NOT_SET(0);

        private final int value;

        private GenerationTypeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static GenerationTypeCase valueOf(int value) {
            return GenerationTypeCase.forNumber(value);
        }

        public static GenerationTypeCase forNumber(int value) {
            switch (value) {
                case 5: {
                    return FINAL_URL_GENERATION;
                }
                case 6: {
                    return FREEFORM_GENERATION;
                }
                case 7: {
                    return PRODUCT_RECONTEXT_GENERATION;
                }
                case 0: {
                    return GENERATIONTYPE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

