/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.services.GoalOperation;
import com.google.ads.googleads.v22.services.GoalServiceSettings;
import com.google.ads.googleads.v22.services.MutateGoalsRequest;
import com.google.ads.googleads.v22.services.MutateGoalsResponse;
import com.google.ads.googleads.v22.services.stub.GoalServiceStub;
import com.google.ads.googleads.v22.services.stub.GoalServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GoalServiceClient
implements BackgroundResource {
    private final GoalServiceSettings settings;
    private final GoalServiceStub stub;

    public static final GoalServiceClient create() throws IOException {
        return GoalServiceClient.create(GoalServiceSettings.newBuilder().build());
    }

    public static final GoalServiceClient create(GoalServiceSettings settings) throws IOException {
        return new GoalServiceClient(settings);
    }

    public static final GoalServiceClient create(GoalServiceStub stub) {
        return new GoalServiceClient(stub);
    }

    protected GoalServiceClient(GoalServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GoalServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GoalServiceClient(GoalServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GoalServiceSettings getSettings() {
        return this.settings;
    }

    public GoalServiceStub getStub() {
        return this.stub;
    }

    public final MutateGoalsResponse mutateGoals(String customerId, List<GoalOperation> operations) {
        MutateGoalsRequest request = MutateGoalsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateGoals(request);
    }

    public final MutateGoalsResponse mutateGoals(MutateGoalsRequest request) {
        return (MutateGoalsResponse)this.mutateGoalsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateGoalsRequest, MutateGoalsResponse> mutateGoalsCallable() {
        return this.stub.mutateGoalsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

