/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.common.LocationInfo;
import com.google.ads.googleads.v22.common.LocationInfoOrBuilder;
import com.google.ads.googleads.v22.enums.AudienceInsightsMarketingObjectiveEnum;
import com.google.ads.googleads.v22.services.AudienceInsightsServiceProto;
import com.google.ads.googleads.v22.services.InsightsAudienceDescriptionOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InsightsAudienceDescription
extends GeneratedMessageV3
implements InsightsAudienceDescriptionOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int COUNTRY_LOCATIONS_FIELD_NUMBER = 1;
    private List<LocationInfo> countryLocations_;
    public static final int AUDIENCE_DESCRIPTION_FIELD_NUMBER = 2;
    private volatile Object audienceDescription_ = "";
    public static final int MARKETING_OBJECTIVE_FIELD_NUMBER = 3;
    private int marketingObjective_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final InsightsAudienceDescription DEFAULT_INSTANCE = new InsightsAudienceDescription();
    private static final Parser<InsightsAudienceDescription> PARSER = new AbstractParser<InsightsAudienceDescription>(){

        public InsightsAudienceDescription parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = InsightsAudienceDescription.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private InsightsAudienceDescription(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private InsightsAudienceDescription() {
        this.countryLocations_ = Collections.emptyList();
        this.audienceDescription_ = "";
        this.marketingObjective_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new InsightsAudienceDescription();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v22_services_InsightsAudienceDescription_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v22_services_InsightsAudienceDescription_fieldAccessorTable.ensureFieldAccessorsInitialized(InsightsAudienceDescription.class, Builder.class);
    }

    @Override
    public List<LocationInfo> getCountryLocationsList() {
        return this.countryLocations_;
    }

    @Override
    public List<? extends LocationInfoOrBuilder> getCountryLocationsOrBuilderList() {
        return this.countryLocations_;
    }

    @Override
    public int getCountryLocationsCount() {
        return this.countryLocations_.size();
    }

    @Override
    public LocationInfo getCountryLocations(int index) {
        return this.countryLocations_.get(index);
    }

    @Override
    public LocationInfoOrBuilder getCountryLocationsOrBuilder(int index) {
        return this.countryLocations_.get(index);
    }

    @Override
    public String getAudienceDescription() {
        Object ref = this.audienceDescription_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.audienceDescription_ = s;
        return s;
    }

    @Override
    public ByteString getAudienceDescriptionBytes() {
        Object ref = this.audienceDescription_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.audienceDescription_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getMarketingObjectiveValue() {
        return this.marketingObjective_;
    }

    @Override
    public AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective getMarketingObjective() {
        AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective result = AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.forNumber(this.marketingObjective_);
        return result == null ? AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.countryLocations_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.countryLocations_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.audienceDescription_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.audienceDescription_);
        }
        if (this.marketingObjective_ != AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.marketingObjective_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.countryLocations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.countryLocations_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.audienceDescription_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.audienceDescription_);
        }
        if (this.marketingObjective_ != AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.marketingObjective_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InsightsAudienceDescription)) {
            return super.equals(obj);
        }
        InsightsAudienceDescription other = (InsightsAudienceDescription)obj;
        if (!this.getCountryLocationsList().equals(other.getCountryLocationsList())) {
            return false;
        }
        if (!this.getAudienceDescription().equals(other.getAudienceDescription())) {
            return false;
        }
        if (this.marketingObjective_ != other.marketingObjective_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + InsightsAudienceDescription.getDescriptor().hashCode();
        if (this.getCountryLocationsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getCountryLocationsList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAudienceDescription().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.marketingObjective_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static InsightsAudienceDescription parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data);
    }

    public static InsightsAudienceDescription parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InsightsAudienceDescription parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data);
    }

    public static InsightsAudienceDescription parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InsightsAudienceDescription parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data);
    }

    public static InsightsAudienceDescription parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InsightsAudienceDescription)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InsightsAudienceDescription parseFrom(InputStream input) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static InsightsAudienceDescription parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InsightsAudienceDescription parseDelimitedFrom(InputStream input) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static InsightsAudienceDescription parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InsightsAudienceDescription parseFrom(CodedInputStream input) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static InsightsAudienceDescription parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InsightsAudienceDescription)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return InsightsAudienceDescription.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsightsAudienceDescription prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static InsightsAudienceDescription getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<InsightsAudienceDescription> parser() {
        return PARSER;
    }

    public Parser<InsightsAudienceDescription> getParserForType() {
        return PARSER;
    }

    public InsightsAudienceDescription getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InsightsAudienceDescriptionOrBuilder {
        private int bitField0_;
        private List<LocationInfo> countryLocations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> countryLocationsBuilder_;
        private Object audienceDescription_ = "";
        private int marketingObjective_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v22_services_InsightsAudienceDescription_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v22_services_InsightsAudienceDescription_fieldAccessorTable.ensureFieldAccessorsInitialized(InsightsAudienceDescription.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.countryLocationsBuilder_ == null) {
                this.countryLocations_ = Collections.emptyList();
            } else {
                this.countryLocations_ = null;
                this.countryLocationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            this.audienceDescription_ = "";
            this.marketingObjective_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AudienceInsightsServiceProto.internal_static_google_ads_googleads_v22_services_InsightsAudienceDescription_descriptor;
        }

        public InsightsAudienceDescription getDefaultInstanceForType() {
            return InsightsAudienceDescription.getDefaultInstance();
        }

        public InsightsAudienceDescription build() {
            InsightsAudienceDescription result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public InsightsAudienceDescription buildPartial() {
            InsightsAudienceDescription result = new InsightsAudienceDescription(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(InsightsAudienceDescription result) {
            if (this.countryLocationsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.countryLocations_ = Collections.unmodifiableList(this.countryLocations_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.countryLocations_ = this.countryLocations_;
            } else {
                result.countryLocations_ = this.countryLocationsBuilder_.build();
            }
        }

        private void buildPartial0(InsightsAudienceDescription result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 2) != 0) {
                result.audienceDescription_ = this.audienceDescription_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.marketingObjective_ = this.marketingObjective_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof InsightsAudienceDescription) {
                return this.mergeFrom((InsightsAudienceDescription)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(InsightsAudienceDescription other) {
            if (other == InsightsAudienceDescription.getDefaultInstance()) {
                return this;
            }
            if (this.countryLocationsBuilder_ == null) {
                if (!other.countryLocations_.isEmpty()) {
                    if (this.countryLocations_.isEmpty()) {
                        this.countryLocations_ = other.countryLocations_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureCountryLocationsIsMutable();
                        this.countryLocations_.addAll(other.countryLocations_);
                    }
                    this.onChanged();
                }
            } else if (!other.countryLocations_.isEmpty()) {
                if (this.countryLocationsBuilder_.isEmpty()) {
                    this.countryLocationsBuilder_.dispose();
                    this.countryLocationsBuilder_ = null;
                    this.countryLocations_ = other.countryLocations_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.countryLocationsBuilder_ = alwaysUseFieldBuilders ? this.getCountryLocationsFieldBuilder() : null;
                } else {
                    this.countryLocationsBuilder_.addAllMessages((Iterable)other.countryLocations_);
                }
            }
            if (!other.getAudienceDescription().isEmpty()) {
                this.audienceDescription_ = other.audienceDescription_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.marketingObjective_ != 0) {
                this.setMarketingObjectiveValue(other.getMarketingObjectiveValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            LocationInfo m = (LocationInfo)input.readMessage(LocationInfo.parser(), extensionRegistry);
                            if (this.countryLocationsBuilder_ == null) {
                                this.ensureCountryLocationsIsMutable();
                                this.countryLocations_.add(m);
                                continue block11;
                            }
                            this.countryLocationsBuilder_.addMessage((AbstractMessage)m);
                            continue block11;
                        }
                        case 18: {
                            this.audienceDescription_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 24: {
                            this.marketingObjective_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureCountryLocationsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.countryLocations_ = new ArrayList<LocationInfo>(this.countryLocations_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<LocationInfo> getCountryLocationsList() {
            if (this.countryLocationsBuilder_ == null) {
                return Collections.unmodifiableList(this.countryLocations_);
            }
            return this.countryLocationsBuilder_.getMessageList();
        }

        @Override
        public int getCountryLocationsCount() {
            if (this.countryLocationsBuilder_ == null) {
                return this.countryLocations_.size();
            }
            return this.countryLocationsBuilder_.getCount();
        }

        @Override
        public LocationInfo getCountryLocations(int index) {
            if (this.countryLocationsBuilder_ == null) {
                return this.countryLocations_.get(index);
            }
            return (LocationInfo)this.countryLocationsBuilder_.getMessage(index);
        }

        public Builder setCountryLocations(int index, LocationInfo value) {
            if (this.countryLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.set(index, value);
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCountryLocations(int index, LocationInfo.Builder builderForValue) {
            if (this.countryLocationsBuilder_ == null) {
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCountryLocations(LocationInfo value) {
            if (this.countryLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.add(value);
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCountryLocations(int index, LocationInfo value) {
            if (this.countryLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.add(index, value);
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCountryLocations(LocationInfo.Builder builderForValue) {
            if (this.countryLocationsBuilder_ == null) {
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCountryLocations(int index, LocationInfo.Builder builderForValue) {
            if (this.countryLocationsBuilder_ == null) {
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCountryLocations(Iterable<? extends LocationInfo> values) {
            if (this.countryLocationsBuilder_ == null) {
                this.ensureCountryLocationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.countryLocations_);
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCountryLocations() {
            if (this.countryLocationsBuilder_ == null) {
                this.countryLocations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeCountryLocations(int index) {
            if (this.countryLocationsBuilder_ == null) {
                this.ensureCountryLocationsIsMutable();
                this.countryLocations_.remove(index);
                this.onChanged();
            } else {
                this.countryLocationsBuilder_.remove(index);
            }
            return this;
        }

        public LocationInfo.Builder getCountryLocationsBuilder(int index) {
            return (LocationInfo.Builder)this.getCountryLocationsFieldBuilder().getBuilder(index);
        }

        @Override
        public LocationInfoOrBuilder getCountryLocationsOrBuilder(int index) {
            if (this.countryLocationsBuilder_ == null) {
                return this.countryLocations_.get(index);
            }
            return (LocationInfoOrBuilder)this.countryLocationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LocationInfoOrBuilder> getCountryLocationsOrBuilderList() {
            if (this.countryLocationsBuilder_ != null) {
                return this.countryLocationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.countryLocations_);
        }

        public LocationInfo.Builder addCountryLocationsBuilder() {
            return (LocationInfo.Builder)this.getCountryLocationsFieldBuilder().addBuilder((AbstractMessage)LocationInfo.getDefaultInstance());
        }

        public LocationInfo.Builder addCountryLocationsBuilder(int index) {
            return (LocationInfo.Builder)this.getCountryLocationsFieldBuilder().addBuilder(index, (AbstractMessage)LocationInfo.getDefaultInstance());
        }

        public List<LocationInfo.Builder> getCountryLocationsBuilderList() {
            return this.getCountryLocationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> getCountryLocationsFieldBuilder() {
            if (this.countryLocationsBuilder_ == null) {
                this.countryLocationsBuilder_ = new RepeatedFieldBuilderV3(this.countryLocations_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.countryLocations_ = null;
            }
            return this.countryLocationsBuilder_;
        }

        @Override
        public String getAudienceDescription() {
            Object ref = this.audienceDescription_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.audienceDescription_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAudienceDescriptionBytes() {
            Object ref = this.audienceDescription_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.audienceDescription_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAudienceDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.audienceDescription_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearAudienceDescription() {
            this.audienceDescription_ = InsightsAudienceDescription.getDefaultInstance().getAudienceDescription();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setAudienceDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InsightsAudienceDescription.checkByteStringIsUtf8((ByteString)value);
            this.audienceDescription_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getMarketingObjectiveValue() {
            return this.marketingObjective_;
        }

        public Builder setMarketingObjectiveValue(int value) {
            this.marketingObjective_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective getMarketingObjective() {
            AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective result = AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.forNumber(this.marketingObjective_);
            return result == null ? AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective.UNRECOGNIZED : result;
        }

        public Builder setMarketingObjective(AudienceInsightsMarketingObjectiveEnum.AudienceInsightsMarketingObjective value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.marketingObjective_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMarketingObjective() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.marketingObjective_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

