/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services.stub;

import com.google.ads.googleads.v22.services.GenerateImagesRequest;
import com.google.ads.googleads.v22.services.GenerateImagesResponse;
import com.google.ads.googleads.v22.services.GenerateTextRequest;
import com.google.ads.googleads.v22.services.GenerateTextResponse;
import com.google.ads.googleads.v22.services.stub.AssetGenerationServiceStub;
import com.google.ads.googleads.v22.services.stub.AssetGenerationServiceStubSettings;
import com.google.ads.googleads.v22.services.stub.GrpcAssetGenerationServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssetGenerationServiceStub
extends AssetGenerationServiceStub {
    private static final MethodDescriptor<GenerateTextRequest, GenerateTextResponse> generateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v22.services.AssetGenerationService/GenerateText").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateTextResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GenerateImagesRequest, GenerateImagesResponse> generateImagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v22.services.AssetGenerationService/GenerateImages").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateImagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateImagesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GenerateTextRequest, GenerateTextResponse> generateTextCallable;
    private final UnaryCallable<GenerateImagesRequest, GenerateImagesResponse> generateImagesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetGenerationServiceStub create(AssetGenerationServiceStubSettings settings) throws IOException {
        return new GrpcAssetGenerationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetGenerationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetGenerationServiceStub(AssetGenerationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetGenerationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetGenerationServiceStub(AssetGenerationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetGenerationServiceStub(AssetGenerationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcAssetGenerationServiceCallableFactory());
    }

    protected GrpcAssetGenerationServiceStub(AssetGenerationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings generateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateTextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings generateImagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateImagesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.generateTextCallable = callableFactory.createUnaryCallable(generateTextTransportSettings, settings.generateTextSettings(), clientContext);
        this.generateImagesCallable = callableFactory.createUnaryCallable(generateImagesTransportSettings, settings.generateImagesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GenerateTextRequest, GenerateTextResponse> generateTextCallable() {
        return this.generateTextCallable;
    }

    @Override
    public UnaryCallable<GenerateImagesRequest, GenerateImagesResponse> generateImagesCallable() {
        return this.generateImagesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

