/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.CampaignAsset;
import com.google.ads.googleads.v9.resources.CampaignAssetName;
import com.google.ads.googleads.v9.services.stub.CampaignAssetServiceStub;
import com.google.ads.googleads.v9.services.stub.CampaignAssetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Service Description: Service to manage campaign assets.
 *
 * <p>This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * <pre>{@code
 * try (CampaignAssetServiceClient campaignAssetServiceClient =
 *     CampaignAssetServiceClient.create()) {
 *   CampaignAssetName resourceName =
 *       CampaignAssetName.of("[CUSTOMER_ID]", "[CAMPAIGN_ID]", "[ASSET_ID]", "[FIELD_TYPE]");
 *   CampaignAsset response = campaignAssetServiceClient.getCampaignAsset(resourceName);
 * }
 * }</pre>
 *
 * <p>Note: close() needs to be called on the CampaignAssetServiceClient object to clean up
 * resources such as threads. In the example above, try-with-resources is used, which automatically
 * calls close().
 *
 * <p>The surface of this class includes several types of Java methods for each of the API's
 * methods:
 *
 * <ol>
 *   <li> A "flattened" method. With this type of method, the fields of the request type have been
 *       converted into function parameters. It may be the case that not all fields are available as
 *       parameters, and not every API method will have a flattened method entry point.
 *   <li> A "request object" method. This type of method only takes one parameter, a request object,
 *       which must be constructed before the call. Not every API method will have a request object
 *       method.
 *   <li> A "callable" method. This type of method takes no parameters and returns an immutable API
 *       callable object, which can be used to initiate calls to the service.
 * </ol>
 *
 * <p>See the individual methods for example code.
 *
 * <p>Many parameters require resource names to be formatted in a particular way. To assist with
 * these names, this class includes a format method for each type of name, and additionally a parse
 * method to extract the individual identifiers contained within names that are returned.
 *
 * <p>This class can be customized by passing in a custom instance of CampaignAssetServiceSettings
 * to create(). For example:
 *
 * <p>To customize credentials:
 *
 * <pre>{@code
 * CampaignAssetServiceSettings campaignAssetServiceSettings =
 *     CampaignAssetServiceSettings.newBuilder()
 *         .setCredentialsProvider(FixedCredentialsProvider.create(myCredentials))
 *         .build();
 * CampaignAssetServiceClient campaignAssetServiceClient =
 *     CampaignAssetServiceClient.create(campaignAssetServiceSettings);
 * }</pre>
 *
 * <p>To customize the endpoint:
 *
 * <pre>{@code
 * CampaignAssetServiceSettings campaignAssetServiceSettings =
 *     CampaignAssetServiceSettings.newBuilder().setEndpoint(myEndpoint).build();
 * CampaignAssetServiceClient campaignAssetServiceClient =
 *     CampaignAssetServiceClient.create(campaignAssetServiceSettings);
 * }</pre>
 *
 * <p>Please refer to the GitHub repository's samples for more quickstart code snippets.
 */
@Generated("by gapic-generator-java")
public class CampaignAssetServiceClient implements BackgroundResource {
  private final CampaignAssetServiceSettings settings;
  private final CampaignAssetServiceStub stub;

  /** Constructs an instance of CampaignAssetServiceClient with default settings. */
  public static final CampaignAssetServiceClient create() throws IOException {
    return create(CampaignAssetServiceSettings.newBuilder().build());
  }

  /**
   * Constructs an instance of CampaignAssetServiceClient, using the given settings. The channels
   * are created based on the settings passed in, or defaults for any settings that are not set.
   */
  public static final CampaignAssetServiceClient create(CampaignAssetServiceSettings settings)
      throws IOException {
    return new CampaignAssetServiceClient(settings);
  }

  /**
   * Constructs an instance of CampaignAssetServiceClient, using the given stub for making calls.
   * This is for advanced usage - prefer using create(CampaignAssetServiceSettings).
   */
  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  public static final CampaignAssetServiceClient create(CampaignAssetServiceStub stub) {
    return new CampaignAssetServiceClient(stub);
  }

  /**
   * Constructs an instance of CampaignAssetServiceClient, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected CampaignAssetServiceClient(CampaignAssetServiceSettings settings) throws IOException {
    this.settings = settings;
    this.stub = ((CampaignAssetServiceStubSettings) settings.getStubSettings()).createStub();
  }

  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  protected CampaignAssetServiceClient(CampaignAssetServiceStub stub) {
    this.settings = null;
    this.stub = stub;
  }

  public final CampaignAssetServiceSettings getSettings() {
    return settings;
  }

  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  public CampaignAssetServiceStub getStub() {
    return stub;
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the requested campaign asset in full detail.
   *
   * <p>List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]()
   * [InternalError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   CampaignAssetName resourceName =
   *       CampaignAssetName.of("[CUSTOMER_ID]", "[CAMPAIGN_ID]", "[ASSET_ID]", "[FIELD_TYPE]");
   *   CampaignAsset response = campaignAssetServiceClient.getCampaignAsset(resourceName);
   * }
   * }</pre>
   *
   * @param resourceName Required. The resource name of the campaign asset to fetch.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final CampaignAsset getCampaignAsset(CampaignAssetName resourceName) {
    GetCampaignAssetRequest request =
        GetCampaignAssetRequest.newBuilder()
            .setResourceName(resourceName == null ? null : resourceName.toString())
            .build();
    return getCampaignAsset(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the requested campaign asset in full detail.
   *
   * <p>List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]()
   * [InternalError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   String resourceName =
   *       CampaignAssetName.of("[CUSTOMER_ID]", "[CAMPAIGN_ID]", "[ASSET_ID]", "[FIELD_TYPE]")
   *           .toString();
   *   CampaignAsset response = campaignAssetServiceClient.getCampaignAsset(resourceName);
   * }
   * }</pre>
   *
   * @param resourceName Required. The resource name of the campaign asset to fetch.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final CampaignAsset getCampaignAsset(String resourceName) {
    GetCampaignAssetRequest request =
        GetCampaignAssetRequest.newBuilder().setResourceName(resourceName).build();
    return getCampaignAsset(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the requested campaign asset in full detail.
   *
   * <p>List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]()
   * [InternalError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   GetCampaignAssetRequest request =
   *       GetCampaignAssetRequest.newBuilder()
   *           .setResourceName(
   *               CampaignAssetName.of(
   *                       "[CUSTOMER_ID]", "[CAMPAIGN_ID]", "[ASSET_ID]", "[FIELD_TYPE]")
   *                   .toString())
   *           .build();
   *   CampaignAsset response = campaignAssetServiceClient.getCampaignAsset(request);
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final CampaignAsset getCampaignAsset(GetCampaignAssetRequest request) {
    return getCampaignAssetCallable().call(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the requested campaign asset in full detail.
   *
   * <p>List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]()
   * [InternalError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   GetCampaignAssetRequest request =
   *       GetCampaignAssetRequest.newBuilder()
   *           .setResourceName(
   *               CampaignAssetName.of(
   *                       "[CUSTOMER_ID]", "[CAMPAIGN_ID]", "[ASSET_ID]", "[FIELD_TYPE]")
   *                   .toString())
   *           .build();
   *   ApiFuture<CampaignAsset> future =
   *       campaignAssetServiceClient.getCampaignAssetCallable().futureCall(request);
   *   // Do something.
   *   CampaignAsset response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<GetCampaignAssetRequest, CampaignAsset> getCampaignAssetCallable() {
    return stub.getCampaignAssetCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Creates, updates, or removes campaign assets. Operation statuses are returned.
   *
   * <p>List of thrown errors: [AssetLinkError]() [AuthenticationError]() [AuthorizationError]()
   * [ContextError]() [DatabaseError]() [FieldError]() [HeaderError]() [InternalError]()
   * [MutateError]() [NotAllowlistedError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   String customerId = "customerId-1581184615";
   *   List<CampaignAssetOperation> operations = new ArrayList<>();
   *   MutateCampaignAssetsResponse response =
   *       campaignAssetServiceClient.mutateCampaignAssets(customerId, operations);
   * }
   * }</pre>
   *
   * @param customerId Required. The ID of the customer whose campaign assets are being modified.
   * @param operations Required. The list of operations to perform on individual campaign assets.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final MutateCampaignAssetsResponse mutateCampaignAssets(
      String customerId, List<CampaignAssetOperation> operations) {
    MutateCampaignAssetsRequest request =
        MutateCampaignAssetsRequest.newBuilder()
            .setCustomerId(customerId)
            .addAllOperations(operations)
            .build();
    return mutateCampaignAssets(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Creates, updates, or removes campaign assets. Operation statuses are returned.
   *
   * <p>List of thrown errors: [AssetLinkError]() [AuthenticationError]() [AuthorizationError]()
   * [ContextError]() [DatabaseError]() [FieldError]() [HeaderError]() [InternalError]()
   * [MutateError]() [NotAllowlistedError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   MutateCampaignAssetsRequest request =
   *       MutateCampaignAssetsRequest.newBuilder()
   *           .setCustomerId("customerId-1581184615")
   *           .addAllOperations(new ArrayList<CampaignAssetOperation>())
   *           .setPartialFailure(true)
   *           .setValidateOnly(true)
   *           .build();
   *   MutateCampaignAssetsResponse response =
   *       campaignAssetServiceClient.mutateCampaignAssets(request);
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final MutateCampaignAssetsResponse mutateCampaignAssets(
      MutateCampaignAssetsRequest request) {
    return mutateCampaignAssetsCallable().call(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Creates, updates, or removes campaign assets. Operation statuses are returned.
   *
   * <p>List of thrown errors: [AssetLinkError]() [AuthenticationError]() [AuthorizationError]()
   * [ContextError]() [DatabaseError]() [FieldError]() [HeaderError]() [InternalError]()
   * [MutateError]() [NotAllowlistedError]() [QuotaError]() [RequestError]()
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (CampaignAssetServiceClient campaignAssetServiceClient =
   *     CampaignAssetServiceClient.create()) {
   *   MutateCampaignAssetsRequest request =
   *       MutateCampaignAssetsRequest.newBuilder()
   *           .setCustomerId("customerId-1581184615")
   *           .addAllOperations(new ArrayList<CampaignAssetOperation>())
   *           .setPartialFailure(true)
   *           .setValidateOnly(true)
   *           .build();
   *   ApiFuture<MutateCampaignAssetsResponse> future =
   *       campaignAssetServiceClient.mutateCampaignAssetsCallable().futureCall(request);
   *   // Do something.
   *   MutateCampaignAssetsResponse response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<MutateCampaignAssetsRequest, MutateCampaignAssetsResponse>
      mutateCampaignAssetsCallable() {
    return stub.mutateCampaignAssetsCallable();
  }

  @Override
  public final void close() {
    stub.close();
  }

  @Override
  public void shutdown() {
    stub.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return stub.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return stub.isTerminated();
  }

  @Override
  public void shutdownNow() {
    stub.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return stub.awaitTermination(duration, unit);
  }
}
