/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerClientName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CLIENT_CUSTOMER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerClients/{client_customer_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String clientCustomerId;

    @Deprecated
    protected CustomerClientName() {
        this.customerId = null;
        this.clientCustomerId = null;
    }

    private CustomerClientName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.clientCustomerId = (String)Preconditions.checkNotNull((Object)builder.getClientCustomerId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerClientName of(String customerId, String clientCustomerId) {
        return CustomerClientName.newBuilder().setCustomerId(customerId).setClientCustomerId(clientCustomerId).build();
    }

    public static String format(String customerId, String clientCustomerId) {
        return CustomerClientName.newBuilder().setCustomerId(customerId).setClientCustomerId(clientCustomerId).build().toString();
    }

    public static CustomerClientName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CLIENT_CUSTOMER_ID.validatedMatch(formattedString, "CustomerClientName.parse: formattedString not in valid format");
        return CustomerClientName.of((String)matchMap.get("customer_id"), (String)matchMap.get("client_customer_id"));
    }

    public static List<CustomerClientName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerClientName> list = new ArrayList<CustomerClientName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerClientName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerClientName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerClientName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CLIENT_CUSTOMER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerClientName customerClientName = this;
            synchronized (customerClientName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.clientCustomerId != null) {
                        fieldMapBuilder.put((Object)"client_customer_id", (Object)this.clientCustomerId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CLIENT_CUSTOMER_ID.instantiate(new String[]{"customer_id", this.customerId, "client_customer_id", this.clientCustomerId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerClientName that = (CustomerClientName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.clientCustomerId, that.clientCustomerId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clientCustomerId);
    }

    public static class Builder {
        private String customerId;
        private String clientCustomerId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getClientCustomerId() {
            return this.clientCustomerId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setClientCustomerId(String clientCustomerId) {
            this.clientCustomerId = clientCustomerId;
            return this;
        }

        private Builder(CustomerClientName customerClientName) {
            this.customerId = customerClientName.customerId;
            this.clientCustomerId = customerClientName.clientCustomerId;
        }

        public CustomerClientName build() {
            return new CustomerClientName(this);
        }
    }
}

