/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.AdScheduleView;
import com.google.ads.googleads.v9.resources.AdScheduleViewName;
import com.google.ads.googleads.v9.services.AdScheduleViewServiceSettings;
import com.google.ads.googleads.v9.services.GetAdScheduleViewRequest;
import com.google.ads.googleads.v9.services.stub.AdScheduleViewServiceStub;
import com.google.ads.googleads.v9.services.stub.AdScheduleViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AdScheduleViewServiceClient
implements BackgroundResource {
    private final AdScheduleViewServiceSettings settings;
    private final AdScheduleViewServiceStub stub;

    public static final AdScheduleViewServiceClient create() throws IOException {
        return AdScheduleViewServiceClient.create(AdScheduleViewServiceSettings.newBuilder().build());
    }

    public static final AdScheduleViewServiceClient create(AdScheduleViewServiceSettings settings) throws IOException {
        return new AdScheduleViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdScheduleViewServiceClient create(AdScheduleViewServiceStub stub) {
        return new AdScheduleViewServiceClient(stub);
    }

    protected AdScheduleViewServiceClient(AdScheduleViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdScheduleViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdScheduleViewServiceClient(AdScheduleViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdScheduleViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdScheduleViewServiceStub getStub() {
        return this.stub;
    }

    public final AdScheduleView getAdScheduleView(AdScheduleViewName resourceName) {
        GetAdScheduleViewRequest request = GetAdScheduleViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdScheduleView(request);
    }

    public final AdScheduleView getAdScheduleView(String resourceName) {
        GetAdScheduleViewRequest request = GetAdScheduleViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdScheduleView(request);
    }

    public final AdScheduleView getAdScheduleView(GetAdScheduleViewRequest request) {
        return (AdScheduleView)this.getAdScheduleViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdScheduleViewRequest, AdScheduleView> getAdScheduleViewCallable() {
        return this.stub.getAdScheduleViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

