/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.CampaignFeed;
import com.google.ads.googleads.v9.resources.CampaignFeedName;
import com.google.ads.googleads.v9.services.CampaignFeedOperation;
import com.google.ads.googleads.v9.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v9.services.GetCampaignFeedRequest;
import com.google.ads.googleads.v9.services.MutateCampaignFeedsRequest;
import com.google.ads.googleads.v9.services.MutateCampaignFeedsResponse;
import com.google.ads.googleads.v9.services.stub.CampaignFeedServiceStub;
import com.google.ads.googleads.v9.services.stub.CampaignFeedServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CampaignFeedServiceClient
implements BackgroundResource {
    private final CampaignFeedServiceSettings settings;
    private final CampaignFeedServiceStub stub;

    public static final CampaignFeedServiceClient create() throws IOException {
        return CampaignFeedServiceClient.create(CampaignFeedServiceSettings.newBuilder().build());
    }

    public static final CampaignFeedServiceClient create(CampaignFeedServiceSettings settings) throws IOException {
        return new CampaignFeedServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignFeedServiceClient create(CampaignFeedServiceStub stub) {
        return new CampaignFeedServiceClient(stub);
    }

    protected CampaignFeedServiceClient(CampaignFeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignFeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignFeedServiceClient(CampaignFeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignFeedServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignFeedServiceStub getStub() {
        return this.stub;
    }

    public final CampaignFeed getCampaignFeed(CampaignFeedName resourceName) {
        GetCampaignFeedRequest request = GetCampaignFeedRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignFeed(request);
    }

    public final CampaignFeed getCampaignFeed(String resourceName) {
        GetCampaignFeedRequest request = GetCampaignFeedRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignFeed(request);
    }

    public final CampaignFeed getCampaignFeed(GetCampaignFeedRequest request) {
        return (CampaignFeed)this.getCampaignFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignFeedRequest, CampaignFeed> getCampaignFeedCallable() {
        return this.stub.getCampaignFeedCallable();
    }

    public final MutateCampaignFeedsResponse mutateCampaignFeeds(String customerId, List<CampaignFeedOperation> operations) {
        MutateCampaignFeedsRequest request = MutateCampaignFeedsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignFeeds(request);
    }

    public final MutateCampaignFeedsResponse mutateCampaignFeeds(MutateCampaignFeedsRequest request) {
        return (MutateCampaignFeedsResponse)this.mutateCampaignFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignFeedsRequest, MutateCampaignFeedsResponse> mutateCampaignFeedsCallable() {
        return this.stub.mutateCampaignFeedsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

