/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.ClickView;
import com.google.ads.googleads.v9.resources.ClickViewName;
import com.google.ads.googleads.v9.services.ClickViewServiceSettings;
import com.google.ads.googleads.v9.services.GetClickViewRequest;
import com.google.ads.googleads.v9.services.stub.ClickViewServiceStub;
import com.google.ads.googleads.v9.services.stub.ClickViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ClickViewServiceClient
implements BackgroundResource {
    private final ClickViewServiceSettings settings;
    private final ClickViewServiceStub stub;

    public static final ClickViewServiceClient create() throws IOException {
        return ClickViewServiceClient.create(ClickViewServiceSettings.newBuilder().build());
    }

    public static final ClickViewServiceClient create(ClickViewServiceSettings settings) throws IOException {
        return new ClickViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ClickViewServiceClient create(ClickViewServiceStub stub) {
        return new ClickViewServiceClient(stub);
    }

    protected ClickViewServiceClient(ClickViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ClickViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ClickViewServiceClient(ClickViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ClickViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ClickViewServiceStub getStub() {
        return this.stub;
    }

    public final ClickView getClickView(ClickViewName resourceName) {
        GetClickViewRequest request = GetClickViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getClickView(request);
    }

    public final ClickView getClickView(String resourceName) {
        GetClickViewRequest request = GetClickViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getClickView(request);
    }

    public final ClickView getClickView(GetClickViewRequest request) {
        return (ClickView)this.getClickViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetClickViewRequest, ClickView> getClickViewCallable() {
        return this.stub.getClickViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

