/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.CustomerNegativeCriterion;
import com.google.ads.googleads.v9.resources.CustomerNegativeCriterionName;
import com.google.ads.googleads.v9.services.CustomerNegativeCriterionOperation;
import com.google.ads.googleads.v9.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v9.services.GetCustomerNegativeCriterionRequest;
import com.google.ads.googleads.v9.services.MutateCustomerNegativeCriteriaRequest;
import com.google.ads.googleads.v9.services.MutateCustomerNegativeCriteriaResponse;
import com.google.ads.googleads.v9.services.stub.CustomerNegativeCriterionServiceStub;
import com.google.ads.googleads.v9.services.stub.CustomerNegativeCriterionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerNegativeCriterionServiceClient
implements BackgroundResource {
    private final CustomerNegativeCriterionServiceSettings settings;
    private final CustomerNegativeCriterionServiceStub stub;

    public static final CustomerNegativeCriterionServiceClient create() throws IOException {
        return CustomerNegativeCriterionServiceClient.create(CustomerNegativeCriterionServiceSettings.newBuilder().build());
    }

    public static final CustomerNegativeCriterionServiceClient create(CustomerNegativeCriterionServiceSettings settings) throws IOException {
        return new CustomerNegativeCriterionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerNegativeCriterionServiceClient create(CustomerNegativeCriterionServiceStub stub) {
        return new CustomerNegativeCriterionServiceClient(stub);
    }

    protected CustomerNegativeCriterionServiceClient(CustomerNegativeCriterionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerNegativeCriterionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerNegativeCriterionServiceClient(CustomerNegativeCriterionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerNegativeCriterionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerNegativeCriterionServiceStub getStub() {
        return this.stub;
    }

    public final CustomerNegativeCriterion getCustomerNegativeCriterion(CustomerNegativeCriterionName resourceName) {
        GetCustomerNegativeCriterionRequest request = GetCustomerNegativeCriterionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerNegativeCriterion(request);
    }

    public final CustomerNegativeCriterion getCustomerNegativeCriterion(String resourceName) {
        GetCustomerNegativeCriterionRequest request = GetCustomerNegativeCriterionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerNegativeCriterion(request);
    }

    public final CustomerNegativeCriterion getCustomerNegativeCriterion(GetCustomerNegativeCriterionRequest request) {
        return (CustomerNegativeCriterion)this.getCustomerNegativeCriterionCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerNegativeCriterionRequest, CustomerNegativeCriterion> getCustomerNegativeCriterionCallable() {
        return this.stub.getCustomerNegativeCriterionCallable();
    }

    public final MutateCustomerNegativeCriteriaResponse mutateCustomerNegativeCriteria(String customerId, List<CustomerNegativeCriterionOperation> operations) {
        MutateCustomerNegativeCriteriaRequest request = MutateCustomerNegativeCriteriaRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerNegativeCriteria(request);
    }

    public final MutateCustomerNegativeCriteriaResponse mutateCustomerNegativeCriteria(MutateCustomerNegativeCriteriaRequest request) {
        return (MutateCustomerNegativeCriteriaResponse)this.mutateCustomerNegativeCriteriaCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerNegativeCriteriaRequest, MutateCustomerNegativeCriteriaResponse> mutateCustomerNegativeCriteriaCallable() {
        return this.stub.mutateCustomerNegativeCriteriaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

