/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.DetailedDemographic;
import com.google.ads.googleads.v9.resources.DetailedDemographicName;
import com.google.ads.googleads.v9.services.DetailedDemographicServiceSettings;
import com.google.ads.googleads.v9.services.GetDetailedDemographicRequest;
import com.google.ads.googleads.v9.services.stub.DetailedDemographicServiceStub;
import com.google.ads.googleads.v9.services.stub.DetailedDemographicServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DetailedDemographicServiceClient
implements BackgroundResource {
    private final DetailedDemographicServiceSettings settings;
    private final DetailedDemographicServiceStub stub;

    public static final DetailedDemographicServiceClient create() throws IOException {
        return DetailedDemographicServiceClient.create(DetailedDemographicServiceSettings.newBuilder().build());
    }

    public static final DetailedDemographicServiceClient create(DetailedDemographicServiceSettings settings) throws IOException {
        return new DetailedDemographicServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DetailedDemographicServiceClient create(DetailedDemographicServiceStub stub) {
        return new DetailedDemographicServiceClient(stub);
    }

    protected DetailedDemographicServiceClient(DetailedDemographicServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DetailedDemographicServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DetailedDemographicServiceClient(DetailedDemographicServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DetailedDemographicServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DetailedDemographicServiceStub getStub() {
        return this.stub;
    }

    public final DetailedDemographic getDetailedDemographic(DetailedDemographicName resourceName) {
        GetDetailedDemographicRequest request = GetDetailedDemographicRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getDetailedDemographic(request);
    }

    public final DetailedDemographic getDetailedDemographic(String resourceName) {
        GetDetailedDemographicRequest request = GetDetailedDemographicRequest.newBuilder().setResourceName(resourceName).build();
        return this.getDetailedDemographic(request);
    }

    public final DetailedDemographic getDetailedDemographic(GetDetailedDemographicRequest request) {
        return (DetailedDemographic)this.getDetailedDemographicCallable().call((Object)request);
    }

    public final UnaryCallable<GetDetailedDemographicRequest, DetailedDemographic> getDetailedDemographicCallable() {
        return this.stub.getDetailedDemographicCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

