/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.Label;
import com.google.ads.googleads.v9.resources.LabelName;
import com.google.ads.googleads.v9.services.GetLabelRequest;
import com.google.ads.googleads.v9.services.LabelOperation;
import com.google.ads.googleads.v9.services.LabelServiceSettings;
import com.google.ads.googleads.v9.services.MutateLabelsRequest;
import com.google.ads.googleads.v9.services.MutateLabelsResponse;
import com.google.ads.googleads.v9.services.stub.LabelServiceStub;
import com.google.ads.googleads.v9.services.stub.LabelServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LabelServiceClient
implements BackgroundResource {
    private final LabelServiceSettings settings;
    private final LabelServiceStub stub;

    public static final LabelServiceClient create() throws IOException {
        return LabelServiceClient.create(LabelServiceSettings.newBuilder().build());
    }

    public static final LabelServiceClient create(LabelServiceSettings settings) throws IOException {
        return new LabelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LabelServiceClient create(LabelServiceStub stub) {
        return new LabelServiceClient(stub);
    }

    protected LabelServiceClient(LabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LabelServiceClient(LabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LabelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LabelServiceStub getStub() {
        return this.stub;
    }

    public final Label getLabel(LabelName resourceName) {
        GetLabelRequest request = GetLabelRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getLabel(request);
    }

    public final Label getLabel(String resourceName) {
        GetLabelRequest request = GetLabelRequest.newBuilder().setResourceName(resourceName).build();
        return this.getLabel(request);
    }

    public final Label getLabel(GetLabelRequest request) {
        return (Label)this.getLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetLabelRequest, Label> getLabelCallable() {
        return this.stub.getLabelCallable();
    }

    public final MutateLabelsResponse mutateLabels(String customerId, List<LabelOperation> operations) {
        MutateLabelsRequest request = MutateLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateLabels(request);
    }

    public final MutateLabelsResponse mutateLabels(MutateLabelsRequest request) {
        return (MutateLabelsResponse)this.mutateLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsCallable() {
        return this.stub.mutateLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

