/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.TopicConstant;
import com.google.ads.googleads.v9.resources.TopicConstantName;
import com.google.ads.googleads.v9.services.GetTopicConstantRequest;
import com.google.ads.googleads.v9.services.TopicConstantServiceSettings;
import com.google.ads.googleads.v9.services.stub.TopicConstantServiceStub;
import com.google.ads.googleads.v9.services.stub.TopicConstantServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TopicConstantServiceClient
implements BackgroundResource {
    private final TopicConstantServiceSettings settings;
    private final TopicConstantServiceStub stub;

    public static final TopicConstantServiceClient create() throws IOException {
        return TopicConstantServiceClient.create(TopicConstantServiceSettings.newBuilder().build());
    }

    public static final TopicConstantServiceClient create(TopicConstantServiceSettings settings) throws IOException {
        return new TopicConstantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TopicConstantServiceClient create(TopicConstantServiceStub stub) {
        return new TopicConstantServiceClient(stub);
    }

    protected TopicConstantServiceClient(TopicConstantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TopicConstantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TopicConstantServiceClient(TopicConstantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TopicConstantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TopicConstantServiceStub getStub() {
        return this.stub;
    }

    public final TopicConstant getTopicConstant(TopicConstantName resourceName) {
        GetTopicConstantRequest request = GetTopicConstantRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getTopicConstant(request);
    }

    public final TopicConstant getTopicConstant(String resourceName) {
        GetTopicConstantRequest request = GetTopicConstantRequest.newBuilder().setResourceName(resourceName).build();
        return this.getTopicConstant(request);
    }

    public final TopicConstant getTopicConstant(GetTopicConstantRequest request) {
        return (TopicConstant)this.getTopicConstantCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicConstantRequest, TopicConstant> getTopicConstantCallable() {
        return this.stub.getTopicConstantCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

