/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services.stub;

import com.google.ads.googleads.v9.resources.AssetGroup;
import com.google.ads.googleads.v9.services.GetAssetGroupRequest;
import com.google.ads.googleads.v9.services.MutateAssetGroupsRequest;
import com.google.ads.googleads.v9.services.MutateAssetGroupsResponse;
import com.google.ads.googleads.v9.services.stub.AssetGroupServiceStub;
import com.google.ads.googleads.v9.services.stub.AssetGroupServiceStubSettings;
import com.google.ads.googleads.v9.services.stub.GrpcAssetGroupServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssetGroupServiceStub
extends AssetGroupServiceStub {
    private static final MethodDescriptor<GetAssetGroupRequest, AssetGroup> getAssetGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.AssetGroupService/GetAssetGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAssetGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AssetGroup.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAssetGroupsRequest, MutateAssetGroupsResponse> mutateAssetGroupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.AssetGroupService/MutateAssetGroups").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAssetGroupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAssetGroupsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetAssetGroupRequest, AssetGroup> getAssetGroupCallable;
    private final UnaryCallable<MutateAssetGroupsRequest, MutateAssetGroupsResponse> mutateAssetGroupsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetGroupServiceStub create(AssetGroupServiceStubSettings settings) throws IOException {
        return new GrpcAssetGroupServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetGroupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetGroupServiceStub(AssetGroupServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetGroupServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetGroupServiceStub(AssetGroupServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetGroupServiceStub(AssetGroupServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcAssetGroupServiceCallableFactory());
    }

    protected GrpcAssetGroupServiceStub(AssetGroupServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAssetGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAssetGroupMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        GrpcCallSettings mutateAssetGroupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAssetGroupsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        this.getAssetGroupCallable = callableFactory.createUnaryCallable(getAssetGroupTransportSettings, settings.getAssetGroupSettings(), clientContext);
        this.mutateAssetGroupsCallable = callableFactory.createUnaryCallable(mutateAssetGroupsTransportSettings, settings.mutateAssetGroupsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAssetGroupRequest, AssetGroup> getAssetGroupCallable() {
        return this.getAssetGroupCallable;
    }

    @Override
    public UnaryCallable<MutateAssetGroupsRequest, MutateAssetGroupsResponse> mutateAssetGroupsCallable() {
        return this.mutateAssetGroupsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

