/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services.stub;

import com.google.ads.googleads.v9.resources.CombinedAudience;
import com.google.ads.googleads.v9.services.GetCombinedAudienceRequest;
import com.google.ads.googleads.v9.services.stub.CombinedAudienceServiceStub;
import com.google.ads.googleads.v9.services.stub.CombinedAudienceServiceStubSettings;
import com.google.ads.googleads.v9.services.stub.GrpcCombinedAudienceServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCombinedAudienceServiceStub
extends CombinedAudienceServiceStub {
    private static final MethodDescriptor<GetCombinedAudienceRequest, CombinedAudience> getCombinedAudienceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.CombinedAudienceService/GetCombinedAudience").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCombinedAudienceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CombinedAudience.getDefaultInstance())).build();
    private final UnaryCallable<GetCombinedAudienceRequest, CombinedAudience> getCombinedAudienceCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCombinedAudienceServiceStub create(CombinedAudienceServiceStubSettings settings) throws IOException {
        return new GrpcCombinedAudienceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCombinedAudienceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCombinedAudienceServiceStub(CombinedAudienceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCombinedAudienceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCombinedAudienceServiceStub(CombinedAudienceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCombinedAudienceServiceStub(CombinedAudienceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcCombinedAudienceServiceCallableFactory());
    }

    protected GrpcCombinedAudienceServiceStub(CombinedAudienceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCombinedAudienceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCombinedAudienceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        this.getCombinedAudienceCallable = callableFactory.createUnaryCallable(getCombinedAudienceTransportSettings, settings.getCombinedAudienceSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCombinedAudienceRequest, CombinedAudience> getCombinedAudienceCallable() {
        return this.getCombinedAudienceCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

