/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services.stub;

import com.google.ads.googleads.v9.resources.ConversionCustomVariable;
import com.google.ads.googleads.v9.services.GetConversionCustomVariableRequest;
import com.google.ads.googleads.v9.services.MutateConversionCustomVariablesRequest;
import com.google.ads.googleads.v9.services.MutateConversionCustomVariablesResponse;
import com.google.ads.googleads.v9.services.stub.ConversionCustomVariableServiceStub;
import com.google.ads.googleads.v9.services.stub.ConversionCustomVariableServiceStubSettings;
import com.google.ads.googleads.v9.services.stub.GrpcConversionCustomVariableServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConversionCustomVariableServiceStub
extends ConversionCustomVariableServiceStub {
    private static final MethodDescriptor<GetConversionCustomVariableRequest, ConversionCustomVariable> getConversionCustomVariableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.ConversionCustomVariableService/GetConversionCustomVariable").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversionCustomVariableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversionCustomVariable.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateConversionCustomVariablesRequest, MutateConversionCustomVariablesResponse> mutateConversionCustomVariablesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.ConversionCustomVariableService/MutateConversionCustomVariables").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateConversionCustomVariablesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateConversionCustomVariablesResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetConversionCustomVariableRequest, ConversionCustomVariable> getConversionCustomVariableCallable;
    private final UnaryCallable<MutateConversionCustomVariablesRequest, MutateConversionCustomVariablesResponse> mutateConversionCustomVariablesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversionCustomVariableServiceStub create(ConversionCustomVariableServiceStubSettings settings) throws IOException {
        return new GrpcConversionCustomVariableServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversionCustomVariableServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversionCustomVariableServiceStub(ConversionCustomVariableServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversionCustomVariableServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversionCustomVariableServiceStub(ConversionCustomVariableServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversionCustomVariableServiceStub(ConversionCustomVariableServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcConversionCustomVariableServiceCallableFactory());
    }

    protected GrpcConversionCustomVariableServiceStub(ConversionCustomVariableServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getConversionCustomVariableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversionCustomVariableMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        GrpcCallSettings mutateConversionCustomVariablesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateConversionCustomVariablesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        this.getConversionCustomVariableCallable = callableFactory.createUnaryCallable(getConversionCustomVariableTransportSettings, settings.getConversionCustomVariableSettings(), clientContext);
        this.mutateConversionCustomVariablesCallable = callableFactory.createUnaryCallable(mutateConversionCustomVariablesTransportSettings, settings.mutateConversionCustomVariablesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetConversionCustomVariableRequest, ConversionCustomVariable> getConversionCustomVariableCallable() {
        return this.getConversionCustomVariableCallable;
    }

    @Override
    public UnaryCallable<MutateConversionCustomVariablesRequest, MutateConversionCustomVariablesResponse> mutateConversionCustomVariablesCallable() {
        return this.mutateConversionCustomVariablesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

