/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAdAssetViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_ID_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAdAssetViews/{ad_group_id}~{ad_id}~{asset_id}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String adId;
    private final String assetId;
    private final String fieldType;

    @Deprecated
    protected AdGroupAdAssetViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.adId = null;
        this.assetId = null;
        this.fieldType = null;
    }

    private AdGroupAdAssetViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.adId = (String)Preconditions.checkNotNull((Object)builder.getAdId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAdId() {
        return this.adId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAdAssetViewName of(String customerId, String adGroupId, String adId, String assetId, String fieldType) {
        return AdGroupAdAssetViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setAssetId(assetId).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String adGroupId, String adId, String assetId, String fieldType) {
        return AdGroupAdAssetViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setAssetId(assetId).setFieldType(fieldType).build().toString();
    }

    public static AdGroupAdAssetViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_ID_FIELD_TYPE.validatedMatch(formattedString, "AdGroupAdAssetViewName.parse: formattedString not in valid format");
        return AdGroupAdAssetViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("ad_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("field_type"));
    }

    public static List<AdGroupAdAssetViewName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdAssetViewName> list = new ArrayList<AdGroupAdAssetViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdAssetViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdAssetViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdAssetViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_ID_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdAssetViewName adGroupAdAssetViewName = this;
            synchronized (adGroupAdAssetViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.adId != null) {
                        fieldMapBuilder.put((Object)"ad_id", (Object)this.adId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_ID_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "ad_id", this.adId, "asset_id", this.assetId, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupAdAssetViewName that = (AdGroupAdAssetViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.adId, that.adId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String adId;
        private String assetId;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAdId() {
            return this.adId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAdId(String adId) {
            this.adId = adId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(AdGroupAdAssetViewName adGroupAdAssetViewName) {
            this.customerId = adGroupAdAssetViewName.customerId;
            this.adGroupId = adGroupAdAssetViewName.adGroupId;
            this.adId = adGroupAdAssetViewName.adId;
            this.assetId = adGroupAdAssetViewName.assetId;
            this.fieldType = adGroupAdAssetViewName.fieldType;
        }

        public AdGroupAdAssetViewName build() {
            return new AdGroupAdAssetViewName(this);
        }
    }
}

