/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PaidOrganicSearchTermViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_BASE64_SEARCH_TERM = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/paidOrganicSearchTermViews/{campaign_id}~{ad_group_id}~{base64_search_term}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String adGroupId;
    private final String base64SearchTerm;

    @Deprecated
    protected PaidOrganicSearchTermViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.adGroupId = null;
        this.base64SearchTerm = null;
    }

    private PaidOrganicSearchTermViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.base64SearchTerm = (String)Preconditions.checkNotNull((Object)builder.getBase64SearchTerm());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getBase64SearchTerm() {
        return this.base64SearchTerm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PaidOrganicSearchTermViewName of(String customerId, String campaignId, String adGroupId, String base64SearchTerm) {
        return PaidOrganicSearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setBase64SearchTerm(base64SearchTerm).build();
    }

    public static String format(String customerId, String campaignId, String adGroupId, String base64SearchTerm) {
        return PaidOrganicSearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAdGroupId(adGroupId).setBase64SearchTerm(base64SearchTerm).build().toString();
    }

    public static PaidOrganicSearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_BASE64_SEARCH_TERM.validatedMatch(formattedString, "PaidOrganicSearchTermViewName.parse: formattedString not in valid format");
        return PaidOrganicSearchTermViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("base64_search_term"));
    }

    public static List<PaidOrganicSearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<PaidOrganicSearchTermViewName> list = new ArrayList<PaidOrganicSearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PaidOrganicSearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PaidOrganicSearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PaidOrganicSearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_BASE64_SEARCH_TERM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PaidOrganicSearchTermViewName paidOrganicSearchTermViewName = this;
            synchronized (paidOrganicSearchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.base64SearchTerm != null) {
                        fieldMapBuilder.put((Object)"base64_search_term", (Object)this.base64SearchTerm);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_AD_GROUP_ID_BASE64_SEARCH_TERM.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "ad_group_id", this.adGroupId, "base64_search_term", this.base64SearchTerm});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PaidOrganicSearchTermViewName that = (PaidOrganicSearchTermViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.base64SearchTerm, that.base64SearchTerm);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.base64SearchTerm);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String adGroupId;
        private String base64SearchTerm;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getBase64SearchTerm() {
            return this.base64SearchTerm;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setBase64SearchTerm(String base64SearchTerm) {
            this.base64SearchTerm = base64SearchTerm;
            return this;
        }

        private Builder(PaidOrganicSearchTermViewName paidOrganicSearchTermViewName) {
            this.customerId = paidOrganicSearchTermViewName.customerId;
            this.campaignId = paidOrganicSearchTermViewName.campaignId;
            this.adGroupId = paidOrganicSearchTermViewName.adGroupId;
            this.base64SearchTerm = paidOrganicSearchTermViewName.base64SearchTerm;
        }

        public PaidOrganicSearchTermViewName build() {
            return new PaidOrganicSearchTermViewName(this);
        }
    }
}

