/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductBiddingCategoryConstantName
implements ResourceName {
    private static final PathTemplate COUNTRY_CODE_LEVEL_ID = PathTemplate.createWithoutUrlEncoding((String)"productBiddingCategoryConstants/{country_code}~{level}~{id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String countryCode;
    private final String level;
    private final String id;

    @Deprecated
    protected ProductBiddingCategoryConstantName() {
        this.countryCode = null;
        this.level = null;
        this.id = null;
    }

    private ProductBiddingCategoryConstantName(Builder builder) {
        this.countryCode = (String)Preconditions.checkNotNull((Object)builder.getCountryCode());
        this.level = (String)Preconditions.checkNotNull((Object)builder.getLevel());
        this.id = (String)Preconditions.checkNotNull((Object)builder.getId());
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getLevel() {
        return this.level;
    }

    public String getId() {
        return this.id;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductBiddingCategoryConstantName of(String countryCode, String level, String id) {
        return ProductBiddingCategoryConstantName.newBuilder().setCountryCode(countryCode).setLevel(level).setId(id).build();
    }

    public static String format(String countryCode, String level, String id) {
        return ProductBiddingCategoryConstantName.newBuilder().setCountryCode(countryCode).setLevel(level).setId(id).build().toString();
    }

    public static ProductBiddingCategoryConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = COUNTRY_CODE_LEVEL_ID.validatedMatch(formattedString, "ProductBiddingCategoryConstantName.parse: formattedString not in valid format");
        return ProductBiddingCategoryConstantName.of((String)matchMap.get("country_code"), (String)matchMap.get("level"), (String)matchMap.get("id"));
    }

    public static List<ProductBiddingCategoryConstantName> parseList(List<String> formattedStrings) {
        ArrayList<ProductBiddingCategoryConstantName> list = new ArrayList<ProductBiddingCategoryConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductBiddingCategoryConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductBiddingCategoryConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductBiddingCategoryConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return COUNTRY_CODE_LEVEL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductBiddingCategoryConstantName productBiddingCategoryConstantName = this;
            synchronized (productBiddingCategoryConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.countryCode != null) {
                        fieldMapBuilder.put((Object)"country_code", (Object)this.countryCode);
                    }
                    if (this.level != null) {
                        fieldMapBuilder.put((Object)"level", (Object)this.level);
                    }
                    if (this.id != null) {
                        fieldMapBuilder.put((Object)"id", (Object)this.id);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return COUNTRY_CODE_LEVEL_ID.instantiate(new String[]{"country_code", this.countryCode, "level", this.level, "id", this.id});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProductBiddingCategoryConstantName that = (ProductBiddingCategoryConstantName)o;
            return Objects.equals(this.countryCode, that.countryCode) && Objects.equals(this.level, that.level) && Objects.equals(this.id, that.id);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.countryCode);
        h *= 1000003;
        h ^= Objects.hashCode(this.level);
        h *= 1000003;
        return h ^= Objects.hashCode(this.id);
    }

    public static class Builder {
        private String countryCode;
        private String level;
        private String id;

        protected Builder() {
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getLevel() {
            return this.level;
        }

        public String getId() {
            return this.id;
        }

        public Builder setCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder setLevel(String level) {
            this.level = level;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        private Builder(ProductBiddingCategoryConstantName productBiddingCategoryConstantName) {
            this.countryCode = productBiddingCategoryConstantName.countryCode;
            this.level = productBiddingCategoryConstantName.level;
            this.id = productBiddingCategoryConstantName.id;
        }

        public ProductBiddingCategoryConstantName build() {
            return new ProductBiddingCategoryConstantName(this);
        }
    }
}

