/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.AdGroupExtensionSetting;
import com.google.ads.googleads.v9.resources.AdGroupExtensionSettingName;
import com.google.ads.googleads.v9.services.AdGroupExtensionSettingOperation;
import com.google.ads.googleads.v9.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v9.services.GetAdGroupExtensionSettingRequest;
import com.google.ads.googleads.v9.services.MutateAdGroupExtensionSettingsRequest;
import com.google.ads.googleads.v9.services.MutateAdGroupExtensionSettingsResponse;
import com.google.ads.googleads.v9.services.stub.AdGroupExtensionSettingServiceStub;
import com.google.ads.googleads.v9.services.stub.AdGroupExtensionSettingServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupExtensionSettingServiceClient
implements BackgroundResource {
    private final AdGroupExtensionSettingServiceSettings settings;
    private final AdGroupExtensionSettingServiceStub stub;

    public static final AdGroupExtensionSettingServiceClient create() throws IOException {
        return AdGroupExtensionSettingServiceClient.create(AdGroupExtensionSettingServiceSettings.newBuilder().build());
    }

    public static final AdGroupExtensionSettingServiceClient create(AdGroupExtensionSettingServiceSettings settings) throws IOException {
        return new AdGroupExtensionSettingServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupExtensionSettingServiceClient create(AdGroupExtensionSettingServiceStub stub) {
        return new AdGroupExtensionSettingServiceClient(stub);
    }

    protected AdGroupExtensionSettingServiceClient(AdGroupExtensionSettingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupExtensionSettingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupExtensionSettingServiceClient(AdGroupExtensionSettingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupExtensionSettingServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupExtensionSettingServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupExtensionSetting getAdGroupExtensionSetting(AdGroupExtensionSettingName resourceName) {
        GetAdGroupExtensionSettingRequest request = GetAdGroupExtensionSettingRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupExtensionSetting(request);
    }

    public final AdGroupExtensionSetting getAdGroupExtensionSetting(String resourceName) {
        GetAdGroupExtensionSettingRequest request = GetAdGroupExtensionSettingRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupExtensionSetting(request);
    }

    public final AdGroupExtensionSetting getAdGroupExtensionSetting(GetAdGroupExtensionSettingRequest request) {
        return (AdGroupExtensionSetting)this.getAdGroupExtensionSettingCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupExtensionSettingRequest, AdGroupExtensionSetting> getAdGroupExtensionSettingCallable() {
        return this.stub.getAdGroupExtensionSettingCallable();
    }

    public final MutateAdGroupExtensionSettingsResponse mutateAdGroupExtensionSettings(String customerId, List<AdGroupExtensionSettingOperation> operations) {
        MutateAdGroupExtensionSettingsRequest request = MutateAdGroupExtensionSettingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupExtensionSettings(request);
    }

    public final MutateAdGroupExtensionSettingsResponse mutateAdGroupExtensionSettings(MutateAdGroupExtensionSettingsRequest request) {
        return (MutateAdGroupExtensionSettingsResponse)this.mutateAdGroupExtensionSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupExtensionSettingsRequest, MutateAdGroupExtensionSettingsResponse> mutateAdGroupExtensionSettingsCallable() {
        return this.stub.mutateAdGroupExtensionSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

