/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.CampaignCriterion;
import com.google.ads.googleads.v9.resources.CampaignCriterionName;
import com.google.ads.googleads.v9.services.CampaignCriterionOperation;
import com.google.ads.googleads.v9.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v9.services.GetCampaignCriterionRequest;
import com.google.ads.googleads.v9.services.MutateCampaignCriteriaRequest;
import com.google.ads.googleads.v9.services.MutateCampaignCriteriaResponse;
import com.google.ads.googleads.v9.services.stub.CampaignCriterionServiceStub;
import com.google.ads.googleads.v9.services.stub.CampaignCriterionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CampaignCriterionServiceClient
implements BackgroundResource {
    private final CampaignCriterionServiceSettings settings;
    private final CampaignCriterionServiceStub stub;

    public static final CampaignCriterionServiceClient create() throws IOException {
        return CampaignCriterionServiceClient.create(CampaignCriterionServiceSettings.newBuilder().build());
    }

    public static final CampaignCriterionServiceClient create(CampaignCriterionServiceSettings settings) throws IOException {
        return new CampaignCriterionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignCriterionServiceClient create(CampaignCriterionServiceStub stub) {
        return new CampaignCriterionServiceClient(stub);
    }

    protected CampaignCriterionServiceClient(CampaignCriterionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignCriterionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignCriterionServiceClient(CampaignCriterionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignCriterionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignCriterionServiceStub getStub() {
        return this.stub;
    }

    public final CampaignCriterion getCampaignCriterion(CampaignCriterionName resourceName) {
        GetCampaignCriterionRequest request = GetCampaignCriterionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignCriterion(request);
    }

    public final CampaignCriterion getCampaignCriterion(String resourceName) {
        GetCampaignCriterionRequest request = GetCampaignCriterionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignCriterion(request);
    }

    public final CampaignCriterion getCampaignCriterion(GetCampaignCriterionRequest request) {
        return (CampaignCriterion)this.getCampaignCriterionCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignCriterionRequest, CampaignCriterion> getCampaignCriterionCallable() {
        return this.stub.getCampaignCriterionCallable();
    }

    public final MutateCampaignCriteriaResponse mutateCampaignCriteria(String customerId, List<CampaignCriterionOperation> operations) {
        MutateCampaignCriteriaRequest request = MutateCampaignCriteriaRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignCriteria(request);
    }

    public final MutateCampaignCriteriaResponse mutateCampaignCriteria(MutateCampaignCriteriaRequest request) {
        return (MutateCampaignCriteriaResponse)this.mutateCampaignCriteriaCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignCriteriaRequest, MutateCampaignCriteriaResponse> mutateCampaignCriteriaCallable() {
        return this.stub.mutateCampaignCriteriaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

