/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.ConversionValueRule;
import com.google.ads.googleads.v9.resources.ConversionValueRuleName;
import com.google.ads.googleads.v9.services.ConversionValueRuleOperation;
import com.google.ads.googleads.v9.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v9.services.GetConversionValueRuleRequest;
import com.google.ads.googleads.v9.services.MutateConversionValueRulesRequest;
import com.google.ads.googleads.v9.services.MutateConversionValueRulesResponse;
import com.google.ads.googleads.v9.services.stub.ConversionValueRuleServiceStub;
import com.google.ads.googleads.v9.services.stub.ConversionValueRuleServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConversionValueRuleServiceClient
implements BackgroundResource {
    private final ConversionValueRuleServiceSettings settings;
    private final ConversionValueRuleServiceStub stub;

    public static final ConversionValueRuleServiceClient create() throws IOException {
        return ConversionValueRuleServiceClient.create(ConversionValueRuleServiceSettings.newBuilder().build());
    }

    public static final ConversionValueRuleServiceClient create(ConversionValueRuleServiceSettings settings) throws IOException {
        return new ConversionValueRuleServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConversionValueRuleServiceClient create(ConversionValueRuleServiceStub stub) {
        return new ConversionValueRuleServiceClient(stub);
    }

    protected ConversionValueRuleServiceClient(ConversionValueRuleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversionValueRuleServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConversionValueRuleServiceClient(ConversionValueRuleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversionValueRuleServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConversionValueRuleServiceStub getStub() {
        return this.stub;
    }

    public final ConversionValueRule getConversionValueRule(ConversionValueRuleName resourceName) {
        GetConversionValueRuleRequest request = GetConversionValueRuleRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getConversionValueRule(request);
    }

    public final ConversionValueRule getConversionValueRule(String resourceName) {
        GetConversionValueRuleRequest request = GetConversionValueRuleRequest.newBuilder().setResourceName(resourceName).build();
        return this.getConversionValueRule(request);
    }

    public final ConversionValueRule getConversionValueRule(GetConversionValueRuleRequest request) {
        return (ConversionValueRule)this.getConversionValueRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversionValueRuleRequest, ConversionValueRule> getConversionValueRuleCallable() {
        return this.stub.getConversionValueRuleCallable();
    }

    public final MutateConversionValueRulesResponse mutateConversionValueRules(String customerId, List<ConversionValueRuleOperation> operations) {
        MutateConversionValueRulesRequest request = MutateConversionValueRulesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateConversionValueRules(request);
    }

    public final MutateConversionValueRulesResponse mutateConversionValueRules(MutateConversionValueRulesRequest request) {
        return (MutateConversionValueRulesResponse)this.mutateConversionValueRulesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateConversionValueRulesRequest, MutateConversionValueRulesResponse> mutateConversionValueRulesCallable() {
        return this.stub.mutateConversionValueRulesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

