/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.CustomerExtensionSetting;
import com.google.ads.googleads.v9.resources.CustomerExtensionSettingName;
import com.google.ads.googleads.v9.services.CustomerExtensionSettingOperation;
import com.google.ads.googleads.v9.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v9.services.GetCustomerExtensionSettingRequest;
import com.google.ads.googleads.v9.services.MutateCustomerExtensionSettingsRequest;
import com.google.ads.googleads.v9.services.MutateCustomerExtensionSettingsResponse;
import com.google.ads.googleads.v9.services.stub.CustomerExtensionSettingServiceStub;
import com.google.ads.googleads.v9.services.stub.CustomerExtensionSettingServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerExtensionSettingServiceClient
implements BackgroundResource {
    private final CustomerExtensionSettingServiceSettings settings;
    private final CustomerExtensionSettingServiceStub stub;

    public static final CustomerExtensionSettingServiceClient create() throws IOException {
        return CustomerExtensionSettingServiceClient.create(CustomerExtensionSettingServiceSettings.newBuilder().build());
    }

    public static final CustomerExtensionSettingServiceClient create(CustomerExtensionSettingServiceSettings settings) throws IOException {
        return new CustomerExtensionSettingServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerExtensionSettingServiceClient create(CustomerExtensionSettingServiceStub stub) {
        return new CustomerExtensionSettingServiceClient(stub);
    }

    protected CustomerExtensionSettingServiceClient(CustomerExtensionSettingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerExtensionSettingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerExtensionSettingServiceClient(CustomerExtensionSettingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerExtensionSettingServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerExtensionSettingServiceStub getStub() {
        return this.stub;
    }

    public final CustomerExtensionSetting getCustomerExtensionSetting(CustomerExtensionSettingName resourceName) {
        GetCustomerExtensionSettingRequest request = GetCustomerExtensionSettingRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerExtensionSetting(request);
    }

    public final CustomerExtensionSetting getCustomerExtensionSetting(String resourceName) {
        GetCustomerExtensionSettingRequest request = GetCustomerExtensionSettingRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerExtensionSetting(request);
    }

    public final CustomerExtensionSetting getCustomerExtensionSetting(GetCustomerExtensionSettingRequest request) {
        return (CustomerExtensionSetting)this.getCustomerExtensionSettingCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerExtensionSettingRequest, CustomerExtensionSetting> getCustomerExtensionSettingCallable() {
        return this.stub.getCustomerExtensionSettingCallable();
    }

    public final MutateCustomerExtensionSettingsResponse mutateCustomerExtensionSettings(String customerId, List<CustomerExtensionSettingOperation> operations) {
        MutateCustomerExtensionSettingsRequest request = MutateCustomerExtensionSettingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerExtensionSettings(request);
    }

    public final MutateCustomerExtensionSettingsResponse mutateCustomerExtensionSettings(MutateCustomerExtensionSettingsRequest request) {
        return (MutateCustomerExtensionSettingsResponse)this.mutateCustomerExtensionSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerExtensionSettingsRequest, MutateCustomerExtensionSettingsResponse> mutateCustomerExtensionSettingsCallable() {
        return this.stub.mutateCustomerExtensionSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

