/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.DistanceView;
import com.google.ads.googleads.v9.resources.DistanceViewName;
import com.google.ads.googleads.v9.services.DistanceViewServiceSettings;
import com.google.ads.googleads.v9.services.GetDistanceViewRequest;
import com.google.ads.googleads.v9.services.stub.DistanceViewServiceStub;
import com.google.ads.googleads.v9.services.stub.DistanceViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DistanceViewServiceClient
implements BackgroundResource {
    private final DistanceViewServiceSettings settings;
    private final DistanceViewServiceStub stub;

    public static final DistanceViewServiceClient create() throws IOException {
        return DistanceViewServiceClient.create(DistanceViewServiceSettings.newBuilder().build());
    }

    public static final DistanceViewServiceClient create(DistanceViewServiceSettings settings) throws IOException {
        return new DistanceViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DistanceViewServiceClient create(DistanceViewServiceStub stub) {
        return new DistanceViewServiceClient(stub);
    }

    protected DistanceViewServiceClient(DistanceViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DistanceViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DistanceViewServiceClient(DistanceViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DistanceViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DistanceViewServiceStub getStub() {
        return this.stub;
    }

    public final DistanceView getDistanceView(DistanceViewName resourceName) {
        GetDistanceViewRequest request = GetDistanceViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getDistanceView(request);
    }

    public final DistanceView getDistanceView(String resourceName) {
        GetDistanceViewRequest request = GetDistanceViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getDistanceView(request);
    }

    public final DistanceView getDistanceView(GetDistanceViewRequest request) {
        return (DistanceView)this.getDistanceViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetDistanceViewRequest, DistanceView> getDistanceViewCallable() {
        return this.stub.getDistanceViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

