/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.DomainCategory;
import com.google.ads.googleads.v9.resources.DomainCategoryName;
import com.google.ads.googleads.v9.services.DomainCategoryServiceSettings;
import com.google.ads.googleads.v9.services.GetDomainCategoryRequest;
import com.google.ads.googleads.v9.services.stub.DomainCategoryServiceStub;
import com.google.ads.googleads.v9.services.stub.DomainCategoryServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DomainCategoryServiceClient
implements BackgroundResource {
    private final DomainCategoryServiceSettings settings;
    private final DomainCategoryServiceStub stub;

    public static final DomainCategoryServiceClient create() throws IOException {
        return DomainCategoryServiceClient.create(DomainCategoryServiceSettings.newBuilder().build());
    }

    public static final DomainCategoryServiceClient create(DomainCategoryServiceSettings settings) throws IOException {
        return new DomainCategoryServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DomainCategoryServiceClient create(DomainCategoryServiceStub stub) {
        return new DomainCategoryServiceClient(stub);
    }

    protected DomainCategoryServiceClient(DomainCategoryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DomainCategoryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DomainCategoryServiceClient(DomainCategoryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DomainCategoryServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DomainCategoryServiceStub getStub() {
        return this.stub;
    }

    public final DomainCategory getDomainCategory(DomainCategoryName resourceName) {
        GetDomainCategoryRequest request = GetDomainCategoryRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getDomainCategory(request);
    }

    public final DomainCategory getDomainCategory(String resourceName) {
        GetDomainCategoryRequest request = GetDomainCategoryRequest.newBuilder().setResourceName(resourceName).build();
        return this.getDomainCategory(request);
    }

    public final DomainCategory getDomainCategory(GetDomainCategoryRequest request) {
        return (DomainCategory)this.getDomainCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetDomainCategoryRequest, DomainCategory> getDomainCategoryCallable() {
        return this.stub.getDomainCategoryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

