/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.FeedItemSetLink;
import com.google.ads.googleads.v9.resources.FeedItemSetLinkName;
import com.google.ads.googleads.v9.services.FeedItemSetLinkOperation;
import com.google.ads.googleads.v9.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v9.services.GetFeedItemSetLinkRequest;
import com.google.ads.googleads.v9.services.MutateFeedItemSetLinksRequest;
import com.google.ads.googleads.v9.services.MutateFeedItemSetLinksResponse;
import com.google.ads.googleads.v9.services.stub.FeedItemSetLinkServiceStub;
import com.google.ads.googleads.v9.services.stub.FeedItemSetLinkServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedItemSetLinkServiceClient
implements BackgroundResource {
    private final FeedItemSetLinkServiceSettings settings;
    private final FeedItemSetLinkServiceStub stub;

    public static final FeedItemSetLinkServiceClient create() throws IOException {
        return FeedItemSetLinkServiceClient.create(FeedItemSetLinkServiceSettings.newBuilder().build());
    }

    public static final FeedItemSetLinkServiceClient create(FeedItemSetLinkServiceSettings settings) throws IOException {
        return new FeedItemSetLinkServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeedItemSetLinkServiceClient create(FeedItemSetLinkServiceStub stub) {
        return new FeedItemSetLinkServiceClient(stub);
    }

    protected FeedItemSetLinkServiceClient(FeedItemSetLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedItemSetLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeedItemSetLinkServiceClient(FeedItemSetLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedItemSetLinkServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeedItemSetLinkServiceStub getStub() {
        return this.stub;
    }

    public final FeedItemSetLink getFeedItemSetLink(FeedItemSetLinkName resourceName) {
        GetFeedItemSetLinkRequest request = GetFeedItemSetLinkRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getFeedItemSetLink(request);
    }

    public final FeedItemSetLink getFeedItemSetLink(String resourceName) {
        GetFeedItemSetLinkRequest request = GetFeedItemSetLinkRequest.newBuilder().setResourceName(resourceName).build();
        return this.getFeedItemSetLink(request);
    }

    public final FeedItemSetLink getFeedItemSetLink(GetFeedItemSetLinkRequest request) {
        return (FeedItemSetLink)this.getFeedItemSetLinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedItemSetLinkRequest, FeedItemSetLink> getFeedItemSetLinkCallable() {
        return this.stub.getFeedItemSetLinkCallable();
    }

    public final MutateFeedItemSetLinksResponse mutateFeedItemSetLinks(String customerId, List<FeedItemSetLinkOperation> operations) {
        MutateFeedItemSetLinksRequest request = MutateFeedItemSetLinksRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeedItemSetLinks(request);
    }

    public final MutateFeedItemSetLinksResponse mutateFeedItemSetLinks(MutateFeedItemSetLinksRequest request) {
        return (MutateFeedItemSetLinksResponse)this.mutateFeedItemSetLinksCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedItemSetLinksRequest, MutateFeedItemSetLinksResponse> mutateFeedItemSetLinksCallable() {
        return this.stub.mutateFeedItemSetLinksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

