/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.Feed;
import com.google.ads.googleads.v9.resources.FeedName;
import com.google.ads.googleads.v9.services.FeedOperation;
import com.google.ads.googleads.v9.services.FeedServiceSettings;
import com.google.ads.googleads.v9.services.GetFeedRequest;
import com.google.ads.googleads.v9.services.MutateFeedsRequest;
import com.google.ads.googleads.v9.services.MutateFeedsResponse;
import com.google.ads.googleads.v9.services.stub.FeedServiceStub;
import com.google.ads.googleads.v9.services.stub.FeedServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedServiceClient
implements BackgroundResource {
    private final FeedServiceSettings settings;
    private final FeedServiceStub stub;

    public static final FeedServiceClient create() throws IOException {
        return FeedServiceClient.create(FeedServiceSettings.newBuilder().build());
    }

    public static final FeedServiceClient create(FeedServiceSettings settings) throws IOException {
        return new FeedServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeedServiceClient create(FeedServiceStub stub) {
        return new FeedServiceClient(stub);
    }

    protected FeedServiceClient(FeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeedServiceClient(FeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeedServiceStub getStub() {
        return this.stub;
    }

    public final Feed getFeed(FeedName resourceName) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(String resourceName) {
        GetFeedRequest request = GetFeedRequest.newBuilder().setResourceName(resourceName).build();
        return this.getFeed(request);
    }

    public final Feed getFeed(GetFeedRequest request) {
        return (Feed)this.getFeedCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.stub.getFeedCallable();
    }

    public final MutateFeedsResponse mutateFeeds(String customerId, List<FeedOperation> operations) {
        MutateFeedsRequest request = MutateFeedsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeeds(request);
    }

    public final MutateFeedsResponse mutateFeeds(MutateFeedsRequest request) {
        return (MutateFeedsResponse)this.mutateFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedsRequest, MutateFeedsResponse> mutateFeedsCallable() {
        return this.stub.mutateFeedsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

