/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services;

import com.google.ads.googleads.v9.resources.KeywordThemeConstant;
import com.google.ads.googleads.v9.resources.KeywordThemeConstantName;
import com.google.ads.googleads.v9.services.GetKeywordThemeConstantRequest;
import com.google.ads.googleads.v9.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v9.services.SuggestKeywordThemeConstantsRequest;
import com.google.ads.googleads.v9.services.SuggestKeywordThemeConstantsResponse;
import com.google.ads.googleads.v9.services.stub.KeywordThemeConstantServiceStub;
import com.google.ads.googleads.v9.services.stub.KeywordThemeConstantServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class KeywordThemeConstantServiceClient
implements BackgroundResource {
    private final KeywordThemeConstantServiceSettings settings;
    private final KeywordThemeConstantServiceStub stub;

    public static final KeywordThemeConstantServiceClient create() throws IOException {
        return KeywordThemeConstantServiceClient.create(KeywordThemeConstantServiceSettings.newBuilder().build());
    }

    public static final KeywordThemeConstantServiceClient create(KeywordThemeConstantServiceSettings settings) throws IOException {
        return new KeywordThemeConstantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KeywordThemeConstantServiceClient create(KeywordThemeConstantServiceStub stub) {
        return new KeywordThemeConstantServiceClient(stub);
    }

    protected KeywordThemeConstantServiceClient(KeywordThemeConstantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordThemeConstantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KeywordThemeConstantServiceClient(KeywordThemeConstantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordThemeConstantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KeywordThemeConstantServiceStub getStub() {
        return this.stub;
    }

    public final KeywordThemeConstant getKeywordThemeConstant(KeywordThemeConstantName resourceName) {
        GetKeywordThemeConstantRequest request = GetKeywordThemeConstantRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getKeywordThemeConstant(request);
    }

    public final KeywordThemeConstant getKeywordThemeConstant(String resourceName) {
        GetKeywordThemeConstantRequest request = GetKeywordThemeConstantRequest.newBuilder().setResourceName(resourceName).build();
        return this.getKeywordThemeConstant(request);
    }

    public final KeywordThemeConstant getKeywordThemeConstant(GetKeywordThemeConstantRequest request) {
        return (KeywordThemeConstant)this.getKeywordThemeConstantCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeywordThemeConstantRequest, KeywordThemeConstant> getKeywordThemeConstantCallable() {
        return this.stub.getKeywordThemeConstantCallable();
    }

    public final SuggestKeywordThemeConstantsResponse suggestKeywordThemeConstants(SuggestKeywordThemeConstantsRequest request) {
        return (SuggestKeywordThemeConstantsResponse)this.suggestKeywordThemeConstantsCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestKeywordThemeConstantsRequest, SuggestKeywordThemeConstantsResponse> suggestKeywordThemeConstantsCallable() {
        return this.stub.suggestKeywordThemeConstantsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

