/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services.stub;

import com.google.ads.googleads.v9.resources.ConversionValueRule;
import com.google.ads.googleads.v9.services.GetConversionValueRuleRequest;
import com.google.ads.googleads.v9.services.MutateConversionValueRulesRequest;
import com.google.ads.googleads.v9.services.MutateConversionValueRulesResponse;
import com.google.ads.googleads.v9.services.stub.ConversionValueRuleServiceStub;
import com.google.ads.googleads.v9.services.stub.ConversionValueRuleServiceStubSettings;
import com.google.ads.googleads.v9.services.stub.GrpcConversionValueRuleServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConversionValueRuleServiceStub
extends ConversionValueRuleServiceStub {
    private static final MethodDescriptor<GetConversionValueRuleRequest, ConversionValueRule> getConversionValueRuleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.ConversionValueRuleService/GetConversionValueRule").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversionValueRuleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversionValueRule.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateConversionValueRulesRequest, MutateConversionValueRulesResponse> mutateConversionValueRulesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.ConversionValueRuleService/MutateConversionValueRules").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateConversionValueRulesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateConversionValueRulesResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetConversionValueRuleRequest, ConversionValueRule> getConversionValueRuleCallable;
    private final UnaryCallable<MutateConversionValueRulesRequest, MutateConversionValueRulesResponse> mutateConversionValueRulesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversionValueRuleServiceStub create(ConversionValueRuleServiceStubSettings settings) throws IOException {
        return new GrpcConversionValueRuleServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversionValueRuleServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversionValueRuleServiceStub(ConversionValueRuleServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversionValueRuleServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversionValueRuleServiceStub(ConversionValueRuleServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversionValueRuleServiceStub(ConversionValueRuleServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcConversionValueRuleServiceCallableFactory());
    }

    protected GrpcConversionValueRuleServiceStub(ConversionValueRuleServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getConversionValueRuleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversionValueRuleMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        GrpcCallSettings mutateConversionValueRulesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateConversionValueRulesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        this.getConversionValueRuleCallable = callableFactory.createUnaryCallable(getConversionValueRuleTransportSettings, settings.getConversionValueRuleSettings(), clientContext);
        this.mutateConversionValueRulesCallable = callableFactory.createUnaryCallable(mutateConversionValueRulesTransportSettings, settings.mutateConversionValueRulesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetConversionValueRuleRequest, ConversionValueRule> getConversionValueRuleCallable() {
        return this.getConversionValueRuleCallable;
    }

    @Override
    public UnaryCallable<MutateConversionValueRulesRequest, MutateConversionValueRulesResponse> mutateConversionValueRulesCallable() {
        return this.mutateConversionValueRulesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

