/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v9.services.stub;

import com.google.ads.googleads.v9.resources.TopicView;
import com.google.ads.googleads.v9.services.GetTopicViewRequest;
import com.google.ads.googleads.v9.services.stub.GrpcTopicViewServiceCallableFactory;
import com.google.ads.googleads.v9.services.stub.TopicViewServiceStub;
import com.google.ads.googleads.v9.services.stub.TopicViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTopicViewServiceStub
extends TopicViewServiceStub {
    private static final MethodDescriptor<GetTopicViewRequest, TopicView> getTopicViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v9.services.TopicViewService/GetTopicView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTopicViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TopicView.getDefaultInstance())).build();
    private final UnaryCallable<GetTopicViewRequest, TopicView> getTopicViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTopicViewServiceStub create(TopicViewServiceStubSettings settings) throws IOException {
        return new GrpcTopicViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTopicViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTopicViewServiceStub(TopicViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTopicViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTopicViewServiceStub(TopicViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTopicViewServiceStub(TopicViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcTopicViewServiceCallableFactory());
    }

    protected GrpcTopicViewServiceStub(TopicViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getTopicViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTopicViewMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
            return params.build();
        }).build();
        this.getTopicViewCallable = callableFactory.createUnaryCallable(getTopicViewTransportSettings, settings.getTopicViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetTopicViewRequest, TopicView> getTopicViewCallable() {
        return this.getTopicViewCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

